/*
 * Decompiled with CFR 0.152.
 */
package Game_Engine.GUI.Components.Input;

import BryceMath.Geometry.Rectangle;
import BryceMath.Numbers.IntB;
import Data_Structures.Structures.IterB;
import Data_Structures.Structures.List;
import Game_Engine.GUI.Components.Input.gui_InputBox;
import java.util.Iterator;
import util.StringParser;

public class gui_IntegerInput
extends gui_InputBox<IntB> {
    private boolean positive = true;
    private boolean changed = false;
    private boolean allow_negatives = true;
    private String default_text = "0";
    private List<Character> data = new List();
    private int max_len = -1;

    public gui_IntegerInput(double x, double y, int w, int h) {
        super(x, y, w, h);
        this.refreshText();
    }

    public gui_IntegerInput(Rectangle r) {
        super(r);
        this.refreshText();
    }

    @Override
    public void forceKeyP(int key) {
        switch (key) {
            case 48: 
            case 96: {
                if (this.data.size() <= 0) break;
                this.data.push(Character.valueOf('0'));
                break;
            }
            case 49: 
            case 97: {
                this.data.push(Character.valueOf('1'));
                break;
            }
            case 50: 
            case 98: {
                this.data.push(Character.valueOf('2'));
                break;
            }
            case 51: 
            case 99: {
                this.data.push(Character.valueOf('3'));
                break;
            }
            case 52: 
            case 100: {
                this.data.push(Character.valueOf('4'));
                break;
            }
            case 53: 
            case 101: {
                this.data.push(Character.valueOf('5'));
                break;
            }
            case 54: 
            case 102: {
                this.data.push(Character.valueOf('6'));
                break;
            }
            case 55: 
            case 103: {
                this.data.push(Character.valueOf('7'));
                break;
            }
            case 56: 
            case 104: {
                this.data.push(Character.valueOf('8'));
                break;
            }
            case 57: 
            case 105: {
                this.data.push(Character.valueOf('9'));
                break;
            }
            case 8: {
                int size = this.data.size();
                if (size > 0) {
                    this.data.pop();
                }
                if (this.positive || size != 0) break;
                this.positive = true;
                break;
            }
            case 45: {
                if (!this.allow_negatives) break;
                this.positive = !this.positive;
                break;
            }
            default: {
                return;
            }
        }
        if (this.max_len > 0 && this.data.size() > this.max_len) {
            this.data.deq();
        }
        this.refreshText();
    }

    @Override
    public void clearInput() {
        this.positive = true;
        this.data = new List();
        this.refreshText();
    }

    @Override
    public IntB getInput() {
        String output = this.getText();
        if (output.equals("-")) {
            return new IntB(-1);
        }
        return new IntB(output);
    }

    public void refreshText() {
        this.setText(this.toString());
        this.changed = true;
    }

    public String toString() {
        if (this.data.isEmpty()) {
            if (this.positive) {
                return this.default_text;
            }
            return "-";
        }
        if (this.positive) {
            return StringParser.charArrToString((Character[])this.data.toArray());
        }
        return "-" + StringParser.charArrToString((Character[])this.data.toArray());
    }

    @Override
    public boolean input_changed() {
        if (this.changed) {
            this.changed = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean query_changed() {
        return this.changed;
    }

    public int getInputSize() {
        return this.data.size();
    }

    void addChar(char c) {
        this.data.add(Character.valueOf(c));
    }

    @Override
    public void update() {
        super.update();
        this.fitToContents();
    }

    public void setDefaultText(String str) {
        this.default_text = str;
        this.changed = true;
        this.refreshText();
    }

    public void disableNegatives() {
        this.allow_negatives = false;
        this.positive = true;
    }

    /*
     * Unable to fully structure code
     */
    public void setMaxLen(int len) {
        this.max_len = len;
        if (this.max_len >= 0) ** GOTO lbl7
        this.max_len = -1;
        return;
lbl-1000:
        // 1 sources

        {
            this.data.deq();
lbl7:
            // 2 sources

            ** while (this.data.size() > this.max_len)
        }
lbl8:
        // 1 sources

    }

    public void populateInput(int i) {
        String str = "" + i;
        IterB<Character> iter2 = StringParser.createIterator(str);
        this.populateInput(iter2);
    }

    public void populateInput(IntB i) {
        String str = "" + i;
        IterB<Character> iter2 = StringParser.createIterator(str);
        this.populateInput(iter2);
    }

    private void populateInput(Iterator<Character> iter2) {
        this.clearInput();
        while (iter2.hasNext()) {
            this.data.push(iter2.next());
        }
        this.refreshText();
    }
}

