/*
 * Decompiled with CFR 0.152.
 */
package Game_Engine.GUI.Components.Input;

import BryceMath.Numbers.Rational;
import Game_Engine.Engine.Objs.ImageB;
import Game_Engine.Engine.Objs.Obj_union;
import Game_Engine.GUI.Components.Input.gui_DecimalInput;
import Game_Engine.GUI.Components.Input.keyInput;
import Game_Engine.GUI.Components.small.boxes.Selectable;
import Game_Engine.GUI.Components.small.boxes.gui_focusBox;
import Game_Engine.GUI.Components.small.gui_look_and_feel;
import java.awt.geom.AffineTransform;

public class gui_RationalInput
extends Obj_union
implements keyInput<Rational>,
Selectable {
    private gui_DecimalInput num;
    private gui_DecimalInput denom;
    private gui_look_and_feel foreground;
    private boolean changed = false;
    private static final int INTEGER_MODE = 0;
    private static final int RATIONAL_MODE = 1;
    private int mode = 0;

    public gui_RationalInput(double x, double y, int w, int h) {
        super(x, y, w, h);
    }

    @Override
    public void iObjs() {
        int borderSize = 2;
        int compH = this.getH() / 2 + borderSize;
        this.denom = new gui_DecimalInput(this.getX() + (double)borderSize, this.getY() + (double)(this.getH() / 2), this.getW() - borderSize * 2, compH - borderSize);
        this.denom.setDrawBorders(false);
        this.obj_create(this.denom);
        this.num = new gui_DecimalInput(this.getX() + (double)borderSize, this.getY() + (double)borderSize, this.getW() - borderSize * 2, compH - borderSize * 2);
        this.num.setDrawBorders(false);
        this.obj_create(this.num);
        this.foreground = new gui_look_and_feel(this.getX(), this.getY(), this.getW(), this.getH());
        this.foreground.makeTransparent();
        this.obj_create(this.foreground);
        this.toIntegerMode();
    }

    @Override
    public void endStep() {
        super.endStep();
        this.fitToContents();
    }

    public void fitToContents() {
        this.num.fitToContents();
        this.denom.fitToContents();
        this.setW(Math.max(this.num.getW() + 4, this.denom.getW()) + 4);
        this.num.setW(this.getW() - 4);
        this.denom.setW(this.getW() - 4);
        this.foreground.setW(super.getW());
    }

    @Override
    public Rational getInput() {
        Rational numerator = this.num.getInput();
        Rational denominator = this.denom.getInput();
        if (numerator == null) {
            numerator = Rational.ONE;
        }
        if (denominator == null) {
            return numerator;
        }
        if (numerator.eq(0) && !denominator.eq(0)) {
            numerator = Rational.ONE;
        }
        if (denominator.eq(0)) {
            return numerator;
        }
        return numerator.div(denominator);
    }

    @Override
    public void clearInput() {
        this.num.clearInput();
        this.denom.clearInput();
        this.toIntegerMode();
    }

    @Override
    public void keyP(int key) {
        if (!this.isSelected()) {
            return;
        }
        this.forceKeyP(key);
    }

    @Override
    public void forceKeyP(int key) {
        switch (key) {
            case 47: 
            case 111: {
                if (this.mode == 0) {
                    this.toRationalMode();
                    this.denom.toggle();
                    return;
                }
                this.denom.toggle();
                return;
            }
            case 8: {
                boolean denom_empty;
                boolean bl = denom_empty = this.denom.toString().length() == 0;
                if (this.mode != 1 || !denom_empty) break;
                this.toIntegerMode();
                this.num.toggle();
                this.breakIteration();
            }
        }
    }

    public void toIntegerMode() {
        this.num.setH(this.getH() - 4);
        this.mode = 0;
    }

    public void toRationalMode() {
        this.num.setH(this.getH() / 2 - 2);
        this.mode = 1;
        if (this.num.getInputSize() == 0) {
            this.num.addChar('1');
            this.num.refreshText();
        }
    }

    @Override
    public void draw(ImageB i, AffineTransform AT) {
        super.draw(i, AT);
    }

    @Override
    public boolean isSelected() {
        gui_focusBox selection = gui_focusBox.selection;
        return selection == this.num || selection == this.denom;
    }

    @Override
    public boolean input_changed() {
        boolean b1 = this.num.input_changed();
        boolean b2 = this.denom.input_changed();
        if (this.changed || b1 || b2) {
            this.changed = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean query_changed() {
        return this.changed || this.num.query_changed() || this.denom.query_changed();
    }

    public void setDefaultText(String str) {
        this.num.setDefaultText(str);
        this.changed = true;
    }

    public String toString() {
        return this.getInput().toString();
    }

    public void toggle() {
        if (this.mode == 0) {
            this.num.toggle();
        } else {
            this.denom.toggle();
        }
    }

    public void setDrawBorders(boolean flag) {
        this.foreground.setDrawBorders(flag);
    }

    public gui_DecimalInput getNum() {
        return this.num;
    }

    public gui_DecimalInput getDenom() {
        return this.denom;
    }
}

