/*
 * Decompiled with CFR 0.152.
 */
package Game_Engine.GUI.Components.Input.textBased;

import BryceMath.Geometry.Rectangle;
import Data_Structures.Operations.Search;
import Data_Structures.Structures.IterB;
import Data_Structures.Structures.List;
import Data_Structures.Structures.Pair;
import Game_Engine.Engine.Objs.Obj;
import Game_Engine.Engine.text.TextManager;
import Game_Engine.GUI.Components.Input.gui_InputBox;
import Game_Engine.GUI.Components.Input.textBased.adt_textField;
import Game_Engine.GUI.Components.small.gui_cursor;
import java.io.PrintStream;
import util.StringParser;

public abstract class gui_textInput<T>
extends gui_InputBox<T>
implements adt_textField {
    private List<Character> data = new List();
    private IterB<Character> iter = this.data.getIter();
    private boolean shift = false;
    private boolean changed = false;
    private static gui_cursor cursor = null;

    public gui_textInput(double x, double y, int w, int h) {
        super(x, y, w, h);
        this.clearInput();
    }

    public gui_textInput(Rectangle r) {
        super(r);
        this.clearInput();
    }

    protected List<Character> getData() {
        return this.data;
    }

    @Override
    public void forceKeyP(int key) {
        if (selection != this) {
            return;
        }
        if (key == 16) {
            this.shift = true;
            return;
        }
        if (!this.handleKeyStroke(key)) {
            return;
        }
        if (this.data.isEmpty()) {
            this.setText("");
            return;
        }
        this.changed = true;
        this.refreshText();
    }

    @Override
    public void refreshText() {
        String str = StringParser.charArrToString((Character[])this.data.toArray());
        if (!this.getText().equals(str)) {
            this.changed = true;
        }
        this.setText(str);
    }

    private boolean handleKeyStroke(int key) {
        switch (key) {
            case 32: {
                cursor.type(' ');
                return true;
            }
        }
        if (this.shift) {
            return this.handleUpperCase(key);
        }
        return this.handleLowerCase(key);
    }

    public boolean handleLowerCase(int key) {
        switch (key) {
            case 192: {
                cursor.type('`');
                break;
            }
            case 47: 
            case 111: {
                cursor.type('/');
                break;
            }
            case 92: {
                cursor.type('\\');
                break;
            }
            case 222: {
                cursor.type('\'');
                break;
            }
            case 61: {
                cursor.type('=');
                break;
            }
            case 59: {
                cursor.type(';');
                break;
            }
            case 48: 
            case 96: {
                cursor.type('0');
                break;
            }
            case 49: 
            case 97: {
                cursor.type('1');
                break;
            }
            case 50: 
            case 98: {
                cursor.type('2');
                break;
            }
            case 51: 
            case 99: {
                cursor.type('3');
                break;
            }
            case 52: 
            case 100: {
                cursor.type('4');
                break;
            }
            case 53: 
            case 101: {
                cursor.type('5');
                break;
            }
            case 54: 
            case 102: {
                cursor.type('6');
                break;
            }
            case 55: 
            case 103: {
                cursor.type('7');
                break;
            }
            case 56: 
            case 104: {
                cursor.type('8');
                break;
            }
            case 57: 
            case 105: {
                cursor.type('9');
                break;
            }
            case 46: {
                cursor.type('.');
                break;
            }
            case 45: 
            case 109: {
                cursor.type('-');
                break;
            }
            case 106: {
                cursor.type('*');
                break;
            }
            case 107: {
                cursor.type('+');
                break;
            }
            case 44: {
                cursor.type(',');
                break;
            }
            case 91: {
                cursor.type('[');
                break;
            }
            case 93: {
                cursor.type(']');
                break;
            }
            case 65: {
                cursor.type('a');
                break;
            }
            case 66: {
                cursor.type('b');
                break;
            }
            case 67: {
                cursor.type('c');
                break;
            }
            case 68: {
                cursor.type('d');
                break;
            }
            case 69: {
                cursor.type('e');
                break;
            }
            case 70: {
                cursor.type('f');
                break;
            }
            case 71: {
                cursor.type('g');
                break;
            }
            case 72: {
                cursor.type('h');
                break;
            }
            case 73: {
                cursor.type('i');
                break;
            }
            case 74: {
                cursor.type('j');
                break;
            }
            case 75: {
                cursor.type('k');
                break;
            }
            case 76: {
                cursor.type('l');
                break;
            }
            case 77: {
                cursor.type('m');
                break;
            }
            case 78: {
                cursor.type('n');
                break;
            }
            case 79: {
                cursor.type('o');
                break;
            }
            case 80: {
                cursor.type('p');
                break;
            }
            case 81: {
                cursor.type('q');
                break;
            }
            case 82: {
                cursor.type('r');
                break;
            }
            case 83: {
                cursor.type('s');
                break;
            }
            case 84: {
                cursor.type('t');
                break;
            }
            case 85: {
                cursor.type('u');
                break;
            }
            case 86: {
                cursor.type('v');
                break;
            }
            case 87: {
                cursor.type('w');
                break;
            }
            case 88: {
                cursor.type('x');
                break;
            }
            case 89: {
                cursor.type('y');
                break;
            }
            case 90: {
                cursor.type('z');
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private boolean handleUpperCase(int key) {
        switch (key) {
            case 192: {
                cursor.type('~');
                break;
            }
            case 59: {
                cursor.type(':');
                break;
            }
            case 47: {
                cursor.type('?');
                break;
            }
            case 92: {
                cursor.type('|');
                break;
            }
            case 222: {
                cursor.type('\"');
                break;
            }
            case 61: {
                cursor.type('+');
                break;
            }
            case 49: {
                cursor.type('!');
                break;
            }
            case 57: {
                cursor.type('(');
                break;
            }
            case 48: {
                cursor.type(')');
                break;
            }
            case 56: {
                cursor.type('*');
                break;
            }
            case 54: {
                cursor.type('^');
                break;
            }
            case 91: {
                cursor.type('{');
                break;
            }
            case 93: {
                cursor.type('}');
                break;
            }
            case 65: {
                cursor.type('A');
                break;
            }
            case 66: {
                cursor.type('B');
                break;
            }
            case 67: {
                cursor.type('C');
                break;
            }
            case 68: {
                cursor.type('D');
                break;
            }
            case 69: {
                cursor.type('E');
                break;
            }
            case 70: {
                cursor.type('F');
                break;
            }
            case 71: {
                cursor.type('G');
                break;
            }
            case 72: {
                cursor.type('H');
                break;
            }
            case 73: {
                cursor.type('I');
                break;
            }
            case 74: {
                cursor.type('J');
                break;
            }
            case 75: {
                cursor.type('K');
                break;
            }
            case 76: {
                cursor.type('L');
                break;
            }
            case 77: {
                cursor.type('M');
                break;
            }
            case 78: {
                cursor.type('N');
                break;
            }
            case 79: {
                cursor.type('O');
                break;
            }
            case 80: {
                cursor.type('P');
                break;
            }
            case 81: {
                cursor.type('Q');
                break;
            }
            case 82: {
                cursor.type('R');
                break;
            }
            case 83: {
                cursor.type('S');
                break;
            }
            case 84: {
                cursor.type('T');
                break;
            }
            case 85: {
                cursor.type('U');
                break;
            }
            case 86: {
                cursor.type('V');
                break;
            }
            case 87: {
                cursor.type('W');
                break;
            }
            case 88: {
                cursor.type('X');
                break;
            }
            case 89: {
                cursor.type('Y');
                break;
            }
            case 90: {
                cursor.type('Z');
                break;
            }
            case 46: {
                cursor.type('>');
                break;
            }
            case 45: {
                cursor.type('_');
                break;
            }
            case 44: {
                cursor.type('<');
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public void keyR(int key) {
        switch (key) {
            case 16: {
                this.shift = false;
                return;
            }
        }
    }

    void add(char c) {
        cursor.type(c);
    }

    @Override
    public void clearInput() {
        this.setFalse();
        this.setText(this.default_text);
        this.data.clear();
        gui_cursor c = cursor;
        if (c != null) {
            c.giveNewLink(this.data.getIter(), 0);
        }
        this.disableTEX();
    }

    @Override
    public boolean input_changed() {
        if (this.changed) {
            this.changed = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean query_changed() {
        return this.changed;
    }

    public void populateInput(String text) {
        this.clearInput();
        int len = text.length();
        int i = 0;
        while (i < len) {
            this.data.add(Character.valueOf(text.charAt(i)));
            ++i;
        }
        this.refreshText();
    }

    public void setDefaultText(String str) {
        this.default_text = str;
    }

    @Override
    public abstract String getSerialName();

    @Override
    public void serializeTo(PrintStream stream) {
        stream.println(StringParser.charArrToString((Character[])this.data.toArray()));
        stream.println();
    }

    @Override
    public IterB<Character> getCharLink(int position) {
        IterB<Character> link = this.data.getIter();
        int i = 0;
        while (i < position && link.hasNext()) {
            link.next();
            ++i;
        }
        return link;
    }

    @Override
    public Pair<Integer, Integer> getCharacterLocation(int position) {
        int x = this.getTextX();
        int y = (int)(this.getY() + (double)(this.getH() / 2) - (double)(this.getTextHeight() / 2));
        String sub = this.getText();
        if (sub.length() > position) {
            sub = this.getText().substring(0, position);
        }
        int offset = TextManager.getLen(sub, false);
        return new Pair<Integer, Integer>(x + offset - 2, y);
    }

    @Override
    public int getTextHeight() {
        return super.getTextSize();
    }

    @Override
    public void toggle() {
        super.toggle();
        if (cursor == null) {
            this.createCursor();
        } else {
            cursor.setHost(this);
        }
    }

    @Override
    public void mouseR(int mx, int my) {
        int[] offsets;
        int index;
        super.mouseR(mx, my);
        if (cursor == null) {
            this.createCursor();
        }
        if ((index = Search.bin_near(offsets = TextManager.getCharacterOffsets(this.getText(), this.getTextSize()), mx - this.getTextX())) == -1) {
            return;
        }
        index = Math.min(offsets.length - 1, index);
        cursor.setHost(this);
        cursor.giveNewLink(this.getCharLink(index), index);
        cursor.setX(this.getTextX() + offsets[index]);
    }

    private void createCursor() {
        cursor = new gui_cursor(this, 0);
        this.myContainer.obj_create((Obj)cursor);
        cursor.setDepth(this.getDepth() - 1);
    }

    private void destroyCursor() {
        if (cursor != null) {
            cursor.kill();
            cursor = null;
        }
    }

    @Override
    public void setFalse() {
        super.setFalse();
        if (cursor != null) {
            this.destroyCursor();
        }
    }

    @Override
    public int getTextLength() {
        return this.data.size();
    }

    @Override
    public IterB<Character> getEndLink() {
        this.iter = this.data.getTailIter();
        return this.iter;
    }

    @Override
    protected void die() {
        this.destroyCursor();
        super.die();
    }
}

