/*
 * Decompiled with CFR 0.152.
 */
package Game_Engine.GUI.Components.large;

import BryceMath.Calculations.Colors;
import Data_Structures.Structures.HashingClasses.Set;
import Game_Engine.Engine.Objs.Obj_union;
import Game_Engine.GUI.Components.Input.textBased.gui_StringInput;
import Game_Engine.GUI.Components.large.gui_list;
import Game_Engine.GUI.Components.small.gui_button;
import Game_Engine.GUI.Components.small.gui_label;
import Game_Engine.GUI.Interfaces.Pingable;
import java.io.File;
import util.FileIO;

public class gui_fileChooser
extends Obj_union
implements Pingable {
    private File current_dir;
    private String current_child = null;
    private File start_dir;
    private Set<String> extensions = new Set();
    private String current_extension;
    private boolean open_mode = true;
    gui_label title;
    public final String NAME = "File Navigator";
    gui_list file_locator;
    gui_label filename_label;
    gui_StringInput filename_input;
    gui_label file_extension_label;
    gui_button op_button;
    gui_button new_folder_button;
    gui_button cancel_button;
    public static final int ROW_H = 100;
    public static final int TITLE_H = 50;
    private boolean flag = false;

    public gui_fileChooser(double x, double y, int w, int h, File file) {
        super(x, y, w, h);
        if (file.isFile()) {
            throw new Error("The file chooser should start within a directory.");
        }
        this.start_dir = this.current_dir = file;
    }

    public gui_fileChooser(double x, double y, int w, int h, String ... path) {
        super(x, y, w, h);
        this.current_dir = FileIO.parseFile(path);
        if (this.current_dir.isFile()) {
            throw new Error("The file chooser should start within a directory.");
        }
        this.start_dir = this.current_dir;
    }

    @Override
    public void iObjs() {
        int w = this.getW();
        int h = this.getH();
        this.title = new gui_label(this.getX(), this.getY(), w, 50);
        this.title.setColor(Colors.C_BLUE_HEADING);
        this.obj_create(this.title);
        this.file_locator = new gui_list(this.getX(), this.title.getY2(), w, h - 200 - 50);
        this.file_locator.setColor(Colors.C_GRAY2);
        this.obj_create(this.file_locator);
        this.refresh();
        int y2 = (int)this.getY2();
        int input_y = y2 - 200;
        this.filename_label = new gui_label(0.0, input_y, w, 100);
        this.filename_label.setText("File Name :");
        this.filename_label.fitToContents();
        this.filename_label.setColor(Colors.C_GRAY2);
        this.obj_create(this.filename_label);
        this.file_extension_label = new gui_label(w - this.filename_label.getW(), input_y, this.filename_label.getW(), 100);
        this.file_extension_label.setColor(Colors.C_GRAY2);
        this.obj_create(this.file_extension_label);
        int input_x = (int)this.filename_label.getX2();
        this.filename_input = new gui_StringInput(input_x, input_y, (int)(this.file_extension_label.getX() - (double)input_x), 100);
        this.filename_input.disableTEX();
        this.obj_create(this.filename_input);
        int button_w = w / 3;
        int x = 0;
        int y = y2 - 100;
        this.op_button = new gui_button(x, y, button_w, 100);
        this.op_button.setText("Open File");
        this.obj_create(this.op_button);
        this.new_folder_button = new gui_button(x += this.op_button.getW(), y, button_w, 100);
        this.new_folder_button.setText("New Folder");
        this.obj_create(this.new_folder_button);
        this.cancel_button = new gui_button(x += this.new_folder_button.getW(), y, button_w, this.op_button.getH());
        this.cancel_button.setText("Cancel");
        this.obj_create(this.cancel_button);
        x += this.cancel_button.getW();
    }

    public void refresh() {
        File f;
        this.title.setText("Directory : " + this.current_dir.getName());
        this.file_locator.clear();
        File parent = this.current_dir.getParentFile();
        if (parent != null) {
            this.createListButton("[Parent] ", parent);
        }
        if (this.current_dir.isFile()) {
            return;
        }
        File[] sub_files = this.current_dir.listFiles();
        if (sub_files == null) {
            gui_label l = new gui_label(0.0, 0.0, this.getW(), 100);
            l.setText("[Empty Directory]");
            this.file_locator.add(l);
            return;
        }
        File[] fileArray = sub_files;
        int n = sub_files.length;
        int n2 = 0;
        while (n2 < n) {
            f = fileArray[n2];
            if (f.isDirectory()) {
                this.createListButton(f);
            }
            ++n2;
        }
        fileArray = sub_files;
        n = sub_files.length;
        n2 = 0;
        while (n2 < n) {
            f = fileArray[n2];
            if (this.properFile(f)) {
                this.createListButton(f);
            }
            ++n2;
        }
    }

    public void addExtensions(String ... allowed) {
        String[] stringArray = allowed;
        int n = allowed.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            this.extensions.set_add(ext);
            this.file_extension_label.setText("." + ext);
            ++n2;
        }
        this.refresh();
    }

    public void removeExtensions(String ... not_allowed) {
        String[] stringArray = not_allowed;
        int n = not_allowed.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            this.extensions.rem(ext);
            ++n2;
        }
        this.refresh();
    }

    private boolean properFile(File file) {
        String extension = FileIO.getExtension(file);
        return this.extensions.includes(extension);
    }

    public void createListButton(File file) {
        this.createListButton(null, file);
    }

    public void createListButton(String prefix, File file) {
        int borderSize = 2;
        fileButton b = new fileButton(0.0, 0.0, this.getW() - borderSize * 2, 100);
        this.file_locator.add(b);
        b.setData(file);
        if (prefix != null) {
            b.setText(String.valueOf(prefix) + b.getText());
        }
    }

    @Override
    public void update() {
        super.update();
        if (this.op_button.flag()) {
            this.current_child = this.filename_input.getInput();
            if (this.open_mode && !this.getFile().exists()) {
                this.filename_input.ERROR("Error : Cannot find File!");
                return;
            }
            if (this.current_child.length() == 0) {
                this.filename_input.ERROR("Please enter a file Name!");
                return;
            }
            this.setFlag(true);
            return;
        }
        if (this.new_folder_button.flag()) {
            this.current_child = this.filename_input.getInput();
            if (this.current_child.equals("")) {
                this.filename_input.ERROR("Invalid Folder Name");
                this.filename_input.setText("");
                return;
            }
            File file = this.getDirectory();
            if (file.exists()) {
                this.filename_input.ERROR("Folder Already Exists");
                this.filename_input.setText("");
                return;
            }
            file.mkdirs();
            this.changeDir(file);
            this.filename_input.clearInput();
            return;
        }
    }

    public void changeDir(File dir_new) {
        this.current_dir = dir_new;
        this.refresh();
    }

    public void startDir() {
        this.changeDir(this.start_dir);
    }

    public void saveMode() {
        this.op_button.setText("Save File");
        this.open_mode = false;
    }

    public void openMode() {
        this.op_button.setText("Open File");
        this.open_mode = true;
    }

    public String getChild() {
        return this.current_child;
    }

    public File getDir() {
        return this.current_dir;
    }

    public File getFile() {
        if (this.current_child == null) {
            return null;
        }
        return FileIO.parseFile(this.current_dir, String.valueOf(this.current_child) + this.file_extension_label.getText());
    }

    public File getDirectory() {
        return FileIO.parseFile(this.current_dir, this.current_child);
    }

    @Override
    public boolean flag() {
        if (this.flag) {
            this.flag = false;
            return true;
        }
        return false;
    }

    @Override
    public void setFlag(boolean flag) {
        this.flag = flag;
    }

    public boolean getCancel() {
        return this.cancel_button.flag();
    }

    @Override
    public void keyP(int key) {
        if (this.filename_input.isSelected() && key == 10) {
            this.op_button.setFlag(true);
        }
    }

    public void setFile(File file) {
        this.current_dir = file.getParentFile();
        this.current_child = FileIO.getChildName(file);
        this.filename_input.populateInput(this.current_child);
        this.refresh();
    }

    private class fileButton
    extends gui_button {
        File myFile;

        public fileButton(double x, double y, int w, int h) {
            super(x, y, w, h);
            this.disableTEX();
        }

        public void setData(File file) {
            this.myFile = file;
            this.myFile.exists();
            this.setText(file.getName());
            if (this.myFile.isDirectory()) {
                this.setRestingColor(Colors.C_BLUE_HEADING);
            }
        }

        @Override
        public void update() {
            super.update();
            if (!this.flag()) {
                return;
            }
            if (this.myFile.isDirectory()) {
                gui_fileChooser.this.changeDir(this.myFile);
                return;
            }
            gui_fileChooser.this.filename_input.populateInput(FileIO.getChildName(this.myFile));
            if (gui_fileChooser.this.open_mode) {
                gui_fileChooser.this.op_button.setFlag(true);
            }
        }
    }
}

