/*
 * Decompiled with CFR 0.152.
 */
package Game_Engine.GUI.Components.large;

import Data_Structures.Structures.List;
import Data_Structures.Structures.UBA;
import Game_Engine.Engine.Objs.Obj;
import Game_Engine.GUI.Components.large.gui_window;
import Game_Engine.GUI.Components.small.boxes.gui_focusBox;
import Game_Engine.GUI.Components.small.gui_button;
import Game_Engine.GUI.Components.small.gui_label;
import util.interfaces.Generator;

public class gui_grid<T extends gui_label>
extends gui_window {
    Generator<T> creator;
    private boolean show_selectors = true;
    private boolean show_creators = true;
    private UBA<UBA<T>> boxes;
    private gui_focusBox selector_all;
    private UBA<gui_focusBox> selector_row;
    private UBA<gui_focusBox> selector_column;
    private gui_button row_add;
    private gui_button column_add;
    private int num_rows = 1;
    private int num_columns = 1;
    private final int ROW_H;
    private static final String selector_row_string = "Select this row";
    private static final String selector_column_string = "Select this column";

    public gui_grid(double x, double y, int w, int h, Generator<T> creator, boolean show_selectors, int ROW_H) {
        super(x, y, w, h);
        this.creator = creator;
        this.show_selectors = show_selectors;
        this.ROW_H = ROW_H;
        this.populateDataWindow();
    }

    private void populateDataWindow() {
        this.boxes = new UBA();
        this.boxes.add(new UBA());
        T first_box = this.I_BOX();
        this.boxes.get(0).add(first_box);
        this.selector_all = new gui_focusBox(0.0, 0.0, 50, 50);
        this.selector_all.setText("All");
        this.obj_create((Obj)this.selector_all);
        this.selector_row = new UBA();
        this.selector_column = new UBA();
        gui_focusBox col_del_0 = this.I_SELECTOR_BUTTON();
        col_del_0.INFO(selector_column_string);
        this.obj_create((Obj)col_del_0);
        this.selector_column.add(col_del_0);
        gui_focusBox row_del_0 = this.I_SELECTOR_BUTTON();
        row_del_0.INFO(selector_row_string);
        this.obj_create((Obj)row_del_0);
        this.selector_row.add(row_del_0);
        this.column_add = new gui_button(50.0, 0.0, 50, this.ROW_H);
        this.row_add = new gui_button(0.0, this.ROW_H * 2, 200, 50);
        this.column_add.setText("+");
        this.row_add.setText("+");
        this.row_add.fitToContents();
        this.obj_create((Obj)this.column_add);
        this.obj_create((Obj)this.row_add);
        this.column_add.INFO("Add a new column to the matrix.");
        this.row_add.INFO("Add a new row to the matrix.");
    }

    @Override
    public void update() {
        super.update();
        this.align();
        this.proccessButtons();
    }

    private void align() {
        int x = 50;
        this.row_add.setX(x);
        this.row_add.setY(50 + this.num_rows * this.ROW_H);
        this.world.setH((int)this.row_add.getY2());
        this.column_add.setH(this.world.getH() - 50 - this.row_add.getH());
        for (UBA<T> column : this.boxes) {
            int x2 = x;
            int y = 50;
            for (gui_label box : column) {
                box.setX(x);
                box.setY(y);
                y = (int)box.getY2();
                box.fitToContents();
                int potential_x2 = (int)box.getX2();
                if (potential_x2 <= x2) continue;
                x2 = potential_x2;
            }
            int w_new = x2 - x;
            for (gui_label box : column) {
                box.setW(w_new);
            }
            x = x2;
        }
        this.column_add.setX(x);
        this.column_add.setY(50.0);
        this.row_add.setW((int)(this.column_add.getX() - this.row_add.getX()));
        this.scrollH((int)this.column_add.getX2());
        this.scrollV((int)this.row_add.getY2());
        this.world.setW((int)this.column_add.getX2());
        int c = 0;
        while (c < this.num_columns) {
            gui_button col_del = this.selector_column.get(c);
            Obj c_0 = (Obj)this.boxes.get(c).get(0);
            col_del.setX(c_0.getX());
            col_del.setY(c_0.getY() - 50.0);
            col_del.setW(c_0.getW());
            ++c;
        }
        int r = 0;
        while (r < this.num_rows) {
            gui_button row_del = this.selector_row.get(r);
            Obj r_0 = (Obj)this.boxes.get(0).get(r);
            row_del.setX(r_0.getX() - 50.0);
            row_del.setY(r_0.getY());
            row_del.setH(r_0.getH());
            ++r;
        }
    }

    private void proccessButtons() {
        if (this.row_add.flag()) {
            this.addRow();
            return;
        }
        if (this.column_add.flag()) {
            this.addCol();
            return;
        }
    }

    public void addRow() {
        for (UBA<T> column : this.boxes) {
            T box_new = this.I_BOX();
            column.add(box_new);
        }
        gui_focusBox row_del = this.I_SELECTOR_BUTTON();
        this.selector_row.add(row_del);
        row_del.INFO(selector_row_string);
        ++this.num_rows;
    }

    public void remRow() {
        this.remRow(this.num_rows - 1);
    }

    public void remRow(int row_index) {
        if (this.num_rows == 1) {
            throw new Error("Cannot remove the last row");
        }
        for (UBA<T> column : this.boxes) {
            ((gui_label)column.delete_and_shift(row_index)).kill();
        }
        this.selector_row.rem().kill();
        --this.num_rows;
    }

    public void addCol() {
        UBA<T> column_new = new UBA<T>();
        int i = 0;
        while (i < this.num_rows) {
            T box_new = this.I_BOX();
            column_new.add(box_new);
            ++i;
        }
        this.boxes.add(column_new);
        gui_focusBox col_del = this.I_SELECTOR_BUTTON();
        col_del.INFO(selector_column_string);
        this.selector_column.add(col_del);
        ++this.num_columns;
    }

    public void remCol() {
        this.remCol(this.num_columns - 1);
    }

    public void remCol(int col_index) {
        if (this.num_columns == 1) {
            throw new Error("Cannot remove the last column.");
        }
        if (col_index < 0 || col_index >= this.boxes.size()) {
            throw new Error("Illegal removal column : " + col_index);
        }
        UBA<T> removables = this.boxes.get(col_index);
        for (gui_label box : removables) {
            box.kill();
        }
        this.selector_column.rem().kill();
        --this.num_columns;
        this.boxes.delete_and_shift(col_index);
    }

    public void shiftRowLeft(int row) {
        this.swapRows(row, row - 1);
    }

    public void shiftRowRight(int row) {
        this.swapRows(row, row + 1);
    }

    public void shiftColumnLeft(int col) {
        this.swapColumns(col, col - 1);
    }

    public void shiftColumnRight(int col) {
        this.swapColumns(col, col + 1);
    }

    public void cycleColumnsLeft(int c1, int c2) {
        int c = c1;
        while (c < c2) {
            this.swapColumns(c, c + 1);
            ++c;
        }
    }

    public void cycleColumnsRight(int c1, int c2) {
        int c = c2;
        while (c > c1) {
            this.swapColumns(c, c - 1);
            --c;
        }
    }

    public void cycleRowsLeft(int r1, int r2) {
        int r = r1;
        while (r < r2) {
            this.swapRows(r, r + 1);
            ++r;
        }
    }

    public void cycleRowsRight(int r1, int r2) {
        int r = r2;
        while (r > r1) {
            this.swapColumns(r, r - 1);
            --r;
        }
    }

    public void swapColumns(int c1, int c2) {
        this.boxes.swap(c1, c2);
    }

    public void swapRows(int r1, int r2) {
        for (UBA<T> col : this.boxes) {
            col.swap(r1, r2);
        }
    }

    private T I_BOX() {
        gui_label output = (gui_label)this.creator.create();
        this.obj_create((Obj)output);
        return (T)output;
    }

    private gui_focusBox I_SELECTOR_BUTTON() {
        gui_focusBox output = new gui_focusBox(-700.0, -700.0, 50, 50);
        output.setText("O");
        this.obj_create((Obj)output);
        return output;
    }

    public T getBox(int row, int col) {
        return (T)((gui_label)this.boxes.get(col).get(row));
    }

    public T getBox(int number) {
        return (T)((gui_label)this.boxes.get(number % this.num_columns).get(number / this.num_columns));
    }

    public int getNumRows() {
        return this.num_rows;
    }

    public int getNumColumns() {
        return this.num_columns;
    }

    public List<T> getSelections() {
        int row = this.getSelectedRow();
        if (row != -1) {
            return this.getRow(row);
        }
        int col = this.getSelectedColumn();
        if (col != -1) {
            return this.getCol(col);
        }
        return null;
    }

    public int getSelectedRow() {
        int row = 0;
        for (gui_focusBox b : this.selector_row) {
            if (b.isLastSelection()) {
                return row;
            }
            ++row;
        }
        return -1;
    }

    public int getSelectedColumn() {
        int col = 0;
        for (gui_focusBox b : this.selector_column) {
            if (b.isLastSelection()) {
                return col;
            }
            ++col;
        }
        return -1;
    }

    public List<T> getCol(int col) {
        return this.boxes.get(col).toList();
    }

    public List<T> getRow(int row) {
        List<gui_label> output = new List<gui_label>();
        for (UBA<T> col : this.boxes) {
            output.add((gui_label)col.get(row));
        }
        return output;
    }

    public List<T> getAll() {
        List<T> output = new List<T>();
        int len = this.num_columns * this.num_rows;
        int i = 0;
        while (i < len) {
            output.add(this.getBox(i));
            ++i;
        }
        return output;
    }
}

