/*
 * Decompiled with CFR 0.152.
 */
package Game_Engine.GUI.Components.large;

import BryceMath.Numbers.Number;
import BryceMath.Structures.Matrix;
import BryceMath.Structures.Vector;
import Data_Structures.Structures.UBA;
import Game_Engine.Engine.Objs.ImageB;
import Game_Engine.Engine.Objs.Obj_union;
import Game_Engine.GUI.Components.large.gui_dragVector;
import Game_Engine.GUI.Components.large.gui_vector;
import Game_Engine.GUI.Components.small.gui_label;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.io.PrintStream;

public class gui_matrix<T extends Number<T>>
extends Obj_union {
    UBA<UBA<gui_label>> boxes;
    Matrix<T> data;
    private int box_size;
    private boolean drawStraightBrackets = false;

    public gui_matrix(double x, double y, Matrix<T> data, int box_size) {
        super(x, y, 1, 1);
        this.data = data;
        this.box_size = box_size;
    }

    @Override
    public void iObjs() {
        Vector<T>[] vectors = this.data.columns();
        int offsetX = 0;
        int h = 0;
        this.boxes = new UBA();
        Vector<T>[] vectorArray = vectors;
        int n = vectors.length;
        int n2 = 0;
        while (n2 < n) {
            Vector<T> v = vectorArray[n2];
            gui_vector<T> gv = new gui_vector<T>(this.getX() + (double)offsetX, this.getY(), v, this.box_size, false);
            gv.initialize();
            UBA<gui_label> col = new UBA<gui_label>();
            int len = gv.size();
            int i = 0;
            while (i < len) {
                gui_label l = gv.getElem(i);
                this.obj_create(l);
                col.add(l);
                ++i;
            }
            this.boxes.add(col);
            offsetX += gv.getW();
            h = gv.getH();
            ++n2;
        }
        this.setH(h);
        this.setW(offsetX);
    }

    public UBA<gui_vector<T>> getRows() {
        Vector<T>[] rows = this.data.rows();
        int w = rows[0].length;
        int h = rows.length;
        UBA<Integer> widths = new UBA<Integer>(w);
        int i = 0;
        while (i < w) {
            widths.add(this.getElem(0, i).getW());
            ++i;
        }
        int compH = this.getElem(0, 0).getH();
        UBA<gui_vector<T>> output = new UBA<gui_vector<T>>(h);
        int i2 = 0;
        while (i2 < h) {
            Vector<T> r = rows[i2];
            output.add(new gui_vector<T>(this.getX(), this.getElem(i2, 0).getY(), r, widths, this.getW(), compH));
            ++i2;
        }
        return output;
    }

    public UBA<gui_dragVector<T>> getDragRows() {
        Vector<T>[] rows = this.data.rows();
        int w = rows[0].length;
        int h = rows.length;
        UBA<Integer> widths = new UBA<Integer>(w);
        int i = 0;
        while (i < w) {
            widths.add(this.getElem(0, i).getW());
            ++i;
        }
        int compH = this.getElem(0, 0).getH();
        UBA<gui_dragVector<T>> output = new UBA<gui_dragVector<T>>(h);
        int i2 = 0;
        while (i2 < h) {
            Vector<T> row_data = rows[i2];
            output.add(new gui_dragVector<T>(this.getX(), this.getElem(i2, 0).getY(), row_data, widths, this.getW(), compH));
            ++i2;
        }
        return output;
    }

    public gui_label getElem(int r, int c) {
        return this.boxes.get(c).get(r);
    }

    public void setStraightBrackets(boolean flag) {
        if (this.drawStraightBrackets != flag) {
            this.redraw();
        }
        this.drawStraightBrackets = flag;
    }

    @Override
    public void draw(ImageB i, AffineTransform AT) {
        int sep = 2;
        int x1 = (int)this.getX() + sep;
        int x2 = x1 + this.getW() - 1 - sep * 2;
        int y1 = (int)this.getY() + sep;
        int y2 = y1 + this.getH() - 1 - sep * 2;
        int bracket_size = this.box_size / 4;
        Graphics2D g = i.getGraphics();
        g.setColor(Color.BLACK);
        int WEIGHT = 3;
        if (!this.drawStraightBrackets) {
            this.fillRect(g, AT, x1, y1, bracket_size, WEIGHT);
            this.fillRect(g, AT, x1, y2 - WEIGHT, bracket_size, WEIGHT);
        }
        this.fillRect(g, AT, x1, y1, WEIGHT, y2 - y1);
        if (!this.drawStraightBrackets) {
            this.fillRect(g, AT, x2 - bracket_size, y1, bracket_size, WEIGHT);
            this.fillRect(g, AT, x2 - bracket_size, y2 - WEIGHT, bracket_size, WEIGHT);
        }
        this.fillRect(g, AT, x2 - WEIGHT, y1, WEIGHT, y2 - y1);
    }

    public Matrix<T> getData() {
        return this.data;
    }

    @Override
    public void serializeTo(PrintStream stream) {
        this.data.serializeTo(stream);
    }

    @Override
    public String getSerialName() {
        return "gui_matrix";
    }
}

