/*
 * Decompiled with CFR 0.152.
 */
package Game_Engine.GUI.Components.large;

import BryceMath.Geometry.Rectangle;
import Data_Structures.Structures.UBA;
import Game_Engine.Engine.Objs.Obj;
import Game_Engine.GUI.Components.large.gui_list;

public class gui_tree
extends gui_list {
    private UBA<TNode> root_nodes = new UBA();
    private int current_branch = 0;

    public gui_tree(double x, double y, int w, int h) {
        super(x, y, w, h);
    }

    public gui_tree(Rectangle r) {
        super(r);
    }

    @Override
    public void add(Obj o) {
        super.add(o);
        if (this.current_branch < this.root_nodes.size()) {
            this.getCurrentLast().add(o);
        } else {
            this.root_nodes.add(new TNode(o));
        }
    }

    public void shiftLeft(int depth) {
        this.redraw();
        if (depth == 0) {
            --this.current_branch;
        } else {
            this.get(depth - 1).branchLeft();
        }
        this.updateData(this.getCurrentPath());
        this.operations.add("ShiftL");
        this.operations.add(depth);
    }

    public void shiftRight(int depth) {
        this.redraw();
        if (depth == 0) {
            ++this.current_branch;
        } else {
            this.get(depth - 1).branchRight();
        }
        this.updateData(this.getCurrentPath());
        this.operations.add("ShiftR");
        this.operations.add(depth);
    }

    private TNode get(int depth) {
        TNode root = this.getRoot();
        if (root == null) {
            throw new Error("Cannot retrieve data from Empty Trees");
        }
        TNode output = root;
        int i = 0;
        while (i < depth) {
            if ((output = output.getNextInPath()) == null) {
                throw new Error("Index : " + depth + " is too deep for this location on this tree.");
            }
            ++i;
        }
        return output;
    }

    private TNode getCurrentLast() {
        TNode root = this.getRoot();
        if (root == null) {
            return null;
        }
        TNode output = root;
        while (output.hasNextInPath()) {
            output = output.getNextInPath();
        }
        return output;
    }

    private UBA<Obj> getCurrentPath() {
        UBA<Obj> output = new UBA<Obj>();
        TNode root = this.getRoot();
        if (root == null) {
            return output;
        }
        TNode node = root;
        output.add(node.getObj());
        while (node.hasNextInPath()) {
            node = node.getNextInPath();
            output.add(node.getObj());
        }
        return output;
    }

    /*
     * Unable to fully structure code
     */
    private TNode getNodeInPath(Obj o) {
        root = this.getRoot();
        if (root == null) {
            return null;
        }
        node = root;
        if (o != TNode.access$6(root)) ** GOTO lbl9
        return root;
lbl-1000:
        // 1 sources

        {
            if (TNode.access$6(node = TNode.access$4(node)) != o) continue;
            return node;
lbl9:
            // 2 sources

            ** while (TNode.access$5((TNode)node))
        }
lbl10:
        // 1 sources

        return null;
    }

    public boolean isLeftNode(Obj o) {
        TNode onode = this.getNodeInPath(o);
        if (onode == null) {
            return false;
        }
        return onode.isLeftNode();
    }

    public boolean isRightNode(Obj o) {
        TNode onode = this.getNodeInPath(o);
        if (onode == null) {
            return false;
        }
        return onode.isRightNode();
    }

    @Override
    public void clear() {
        super.clear();
        this.root_nodes.clear();
    }

    public boolean has_non_trivial_branchRight(int depth) {
        TNode node = this.get(depth);
        int current_branch = node.current_branch;
        UBA<TNode> branches = node.branches;
        if (current_branch + 1 > branches.size() - 1) {
            return false;
        }
        return branches.get(current_branch + 1) != null;
    }

    public boolean has_non_tivial_branchLeft(int depth) {
        TNode node = this.get(depth);
        return !node.isLeftNode();
    }

    private TNode getRoot() {
        if (this.current_branch < this.root_nodes.size()) {
            return this.root_nodes.get(this.current_branch);
        }
        return null;
    }

    public int getRootNum() {
        return this.root_nodes.size();
    }

    public int getCurrentRootBranch() {
        return this.current_branch;
    }

    @Override
    public int getIndex(Obj o) {
        return super.getIndex(o) + 1;
    }

    @Override
    public void rem() {
        throw new Error("Not supported");
    }

    @Override
    public void deq() {
        throw new Error("Not supported");
    }

    private class TNode {
        Obj myObj;
        UBA<TNode> branches = new UBA();
        int current_branch = -1;

        private TNode(Obj o) {
            this.myObj = o;
        }

        private void add(Obj o) {
            this.branches.add(new TNode(o));
            this.current_branch = this.branches.size() - 1;
        }

        private TNode getNextInPath() {
            if (this.current_branch == -1 || this.current_branch == this.branches.size()) {
                return null;
            }
            return this.branches.get(this.current_branch);
        }

        private boolean hasNextInPath() {
            return this.current_branch != -1 && this.current_branch != this.branches.size();
        }

        private void branchLeft() {
            if (this.current_branch > 0) {
                --this.current_branch;
            }
        }

        private void branchRight() {
            if (this.current_branch < this.branches.size()) {
                ++this.current_branch;
            }
        }

        private Obj getObj() {
            return this.myObj;
        }

        private boolean isLeftNode() {
            return this.current_branch < 1;
        }

        private boolean isRightNode() {
            return this.current_branch >= gui_tree.this.data.size() - 1;
        }
    }
}

