/*
 * Decompiled with CFR 0.152.
 */
package Game_Engine.GUI.Components.large;

import BryceMath.Calculations.Colors;
import BryceMath.Numbers.Number;
import BryceMath.Structures.Vector;
import Data_Structures.Structures.UBA;
import Game_Engine.Engine.Objs.ImageB;
import Game_Engine.Engine.Objs.Obj_union;
import Game_Engine.Engine.text.TextManager;
import Game_Engine.GUI.Components.small.gui_label;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

public class gui_vector<T extends Number<T>>
extends Obj_union {
    UBA<gui_label> boxes;
    Vector<T> data;
    private int box_size;
    private final boolean hori;
    private boolean draw_borders = true;
    private UBA<Integer> widths;
    public static Color color = Colors.C_CLEAR;

    public gui_vector(Vector<T> data, int size, boolean hori) {
        super(0.0, 0.0, size * data.length, size);
        this.data = data;
        this.box_size = size;
        this.hori = hori;
    }

    public gui_vector(double x, double y, Vector<T> data, int size, boolean hori) {
        super(x, y, size * data.length, size);
        this.data = data;
        this.box_size = size;
        this.hori = hori;
    }

    public gui_vector(double x, double y, Vector<T> data, UBA<Integer> widths, int w, int h) {
        super(x, y, w, h);
        this.data = data;
        this.box_size = h;
        this.hori = true;
        this.widths = widths;
    }

    @Override
    public void iObjs() {
        if (this.hori) {
            this.iHori();
        } else {
            this.iVert();
        }
    }

    private void iHori() {
        int len = this.data.length;
        this.boxes = new UBA(len);
        int offset = 0;
        int i = 0;
        while (i < len) {
            String message = ((Number)this.data.get(i)).toString();
            int box_w = this.widths == null ? this.getBoxW(message) : this.widths.get(i).intValue();
            gui_label h = new gui_label(this.getX() + (double)offset, this.getY(), box_w, this.box_size);
            h.setColor(color);
            offset += box_w;
            h.setText(message);
            this.boxes.add(h);
            this.obj_create(h);
            ++i;
        }
        this.setW(offset);
    }

    private void iVert() {
        int len = this.data.length;
        UBA<String> messages = new UBA<String>(len);
        int max_len = 0;
        for (Number r : this.data) {
            String message = r.toString();
            messages.add(message);
            int message_len = this.getBoxW(message);
            if (message_len <= max_len) continue;
            max_len = message_len;
        }
        int box_w = max_len;
        this.boxes = new UBA(len);
        int i = 0;
        while (i < len) {
            this.I_SCALARLABEL(messages, i, box_w);
            ++i;
        }
        this.setH(len * this.box_size);
        this.setW(box_w);
    }

    private void I_SCALARLABEL(UBA<String> messages, int i, int box_w) {
        gui_label h = new gui_label(this.getX(), this.getY() + (double)(i * this.box_size), box_w, this.box_size);
        h.setColor(color);
        h.setText(messages.get(i));
        this.boxes.add(h);
        this.obj_create(h);
    }

    private int getBoxW(String message) {
        return Math.max(TextManager.getLen(message, true) + 25, this.box_size);
    }

    public int size() {
        return this.boxes.size();
    }

    public gui_label getElem(int n) {
        return this.boxes.get(n);
    }

    public Vector<T> getData() {
        return this.data;
    }

    public void setDrawBorders(boolean flag) {
        this.draw_borders = flag;
    }

    @Override
    public void draw(ImageB i, AffineTransform AT) {
        if (!this.draw_borders) {
            return;
        }
        int sep = 2;
        int x1 = (int)this.getX() + sep;
        int x2 = x1 + this.getW() - 1 - sep * 2;
        int y1 = (int)this.getY() + sep;
        int y2 = y1 + this.getH() - 1 - sep * 2;
        int bracket_size = this.box_size / 4;
        Graphics2D g = i.getGraphics();
        g.setColor(Color.BLACK);
        this.drawLine(g, AT, x1, y1, x1 + bracket_size, y1);
        this.drawLine(g, AT, x1, y1, x1, y2);
        this.drawLine(g, AT, x1, y2, x1 + bracket_size, y2);
        this.drawLine(g, AT, x2, y1, x2 - bracket_size, y1);
        this.drawLine(g, AT, x2, y1, x2, y2);
        this.drawLine(g, AT, x2, y2, x2 - bracket_size, y2);
    }

    public void makeTransparent() {
        for (gui_label l : this.boxes) {
            l.makeTransparent();
        }
    }
}

