/*
 * Decompiled with CFR 0.152.
 */
package Game_Engine.GUI.Components.sets;

import Data_Structures.ADTs.Pairable;
import Data_Structures.Structures.List;
import Data_Structures.Structures.UBA;
import Game_Engine.Engine.Objs.Obj_union;
import Game_Engine.GUI.Components.small.boxes.gui_boolean;
import Game_Engine.GUI.Components.small.boxes.gui_checkBox;
import Game_Engine.GUI.Components.small.gui_button;
import java.awt.image.BufferedImage;

public class Secondary_button_set
extends Obj_union {
    UBA<gui_checkBox> primary_buttons = new UBA();
    UBA<gui_button> secondary_buttons = new UBA();
    BufferedImage secondary_image = null;
    int matrixH;
    int matrixW;
    private boolean secondary_visible = true;
    private int swap1;

    public Secondary_button_set(double x, double y, int w, int h, int matrixW, int matrixH) {
        super(x, y, w, h);
        if (matrixH < 1 || matrixW < 1) {
            throw new Error("Buttons sets cannot have trivial sizes.");
        }
        this.matrixH = matrixH;
        this.matrixW = matrixW;
    }

    @Override
    public void iObjs() {
        int r = 0;
        while (r < this.matrixH) {
            int c = 0;
            while (c < this.matrixW) {
                gui_checkBox b = new gui_checkBox((int)(this.getX() + (double)this.getW() * 1.0 * (double)c / (double)this.matrixW), (int)(this.getY() + (double)this.getH() * 1.0 * (double)r / (double)this.matrixH), this.getW() / this.matrixW, this.getH() / this.matrixH);
                this.obj_create(b);
                this.primary_buttons.add(b);
                gui_button b2 = new gui_button(b.getX(), b.getY(), b.getW(), b.getH());
                this.secondary_buttons.add(b2);
                this.obj_create(b2);
                b2.setImage(this.secondary_image);
                ++c;
            }
            ++r;
        }
        this.hide_secondary_buttons();
    }

    @Override
    public void update() {
        int len = this.primary_buttons.size();
        int i = 0;
        while (i < len) {
            gui_boolean b = this.primary_buttons.get(i);
            if (b.query()) {
                this.swap1 = i;
                if (!this.secondary_visible) {
                    this.show_secondary_buttons(i);
                }
                return;
            }
            ++i;
        }
        this.swap1 = -1;
        if (this.secondary_visible) {
            this.hide_secondary_buttons();
        }
    }

    public void show_secondary_buttons(int skip_index) {
        this.secondary_visible = true;
        for (gui_boolean gui_boolean2 : this.primary_buttons) {
            gui_boolean2.setVisible(false);
        }
        for (gui_button gui_button2 : this.secondary_buttons) {
            gui_button2.setVisible(true);
        }
        this.primary_buttons.get(skip_index).setVisible(true);
        this.secondary_buttons.get(skip_index).setVisible(false);
    }

    private void hide_secondary_buttons() {
        this.secondary_visible = false;
        for (gui_button gui_button2 : this.secondary_buttons) {
            gui_button2.setVisible(false);
        }
        for (gui_boolean gui_boolean2 : this.primary_buttons) {
            gui_boolean2.setVisible(true);
        }
    }

    public void reset() {
        for (gui_boolean gui_boolean2 : this.primary_buttons) {
            gui_boolean2.setFalse();
        }
        this.hide_secondary_buttons();
    }

    public Pairable<Integer> getSwaps() {
        int i = 0;
        for (gui_button b : this.secondary_buttons) {
            if (b.flag()) {
                List<Integer> output = new List<Integer>();
                output.append(this.swap1, i);
                return output;
            }
            ++i;
        }
        return null;
    }

    public int getSwap1() {
        return this.swap1;
    }

    public void setMessages(String primary1, String primary2, String secondary) {
        if (!this.initialized) {
            this.initialize();
        }
        for (gui_checkBox gui_checkBox2 : this.primary_buttons) {
            gui_checkBox2.setMessages(primary1, primary2);
        }
        for (gui_button gui_button2 : this.secondary_buttons) {
            gui_button2.setText(secondary);
        }
    }

    public void set_image_secondary(BufferedImage image) {
        this.secondary_image = image;
    }

    public UBA<gui_checkBox> get_primary_buttons() {
        return this.primary_buttons;
    }

    public UBA<gui_button> get_secondary_buttons() {
        return this.secondary_buttons;
    }
}

