/*
 * Decompiled with CFR 0.152.
 */
package Game_Engine.GUI.Components.small;

import BryceMath.Calculations.Colors;
import Data_Structures.Structures.IterB;
import Data_Structures.Structures.Pair;
import Data_Structures.Structures.Timing.TimeB;
import Game_Engine.GUI.Components.Input.textBased.adt_textField;
import Game_Engine.GUI.Components.small.gui_label;
import java.awt.Color;

public class gui_cursor
extends gui_label {
    private adt_textField host_field;
    private int character_position = 0;
    private IterB<Character> character_iterator;
    TimeB blink_timer;
    private static Color C_OFF = Color.BLACK;
    private static Color C_ON = Colors.C_CLEAR;

    public gui_cursor(adt_textField t, int position) {
        super(0.0, 0.0, 2, 1);
        this.host_field = t;
        this.character_position = position;
        this.character_iterator = t.getCharLink(position);
        this.blink_timer = new TimeB(12);
        this.setH(t.getTextHeight());
        this.updatePosition();
    }

    @Override
    public void update() {
        if (this.blink_timer.flag()) {
            this.blink();
        }
    }

    private void blink() {
        if (this.getColor() == C_OFF) {
            this.setColor(C_ON);
        } else {
            this.setColor(C_OFF);
        }
    }

    @Override
    public void keyP(int key) {
        switch (key) {
            case 35: {
                this.character_position = this.host_field.getTextLength() + 1;
                this.character_iterator = this.host_field.getEndLink();
                this.character_iterator.previous();
                break;
            }
            case 36: {
                if (this.host_field.getTextLength() == 0) break;
                this.character_position = 0;
                this.character_iterator = this.host_field.getCharLink(0);
                this.character_iterator.next();
                break;
            }
            case 8: {
                if (!this.character_iterator.hasCurrent()) break;
                this.character_iterator.remove();
                if (this.character_iterator.hasPrevious()) {
                    this.character_iterator.previous();
                }
                this.host_field.refreshText();
                --this.character_position;
                break;
            }
            case 127: {
                if (this.character_iterator.hasNext()) {
                    this.character_iterator.next();
                    this.character_iterator.remove();
                    this.host_field.refreshText();
                    if (!this.character_iterator.hasPrevious()) break;
                    this.character_iterator.previous();
                    break;
                }
                if (this.character_position != 0 || !this.character_iterator.hasCurrent()) break;
                this.character_iterator.remove();
                this.host_field.refreshText();
                break;
            }
            case 37: {
                if (this.character_iterator.hasPrevious()) {
                    this.character_iterator.previous();
                    --this.character_position;
                    break;
                }
                this.character_position = 0;
                break;
            }
            case 39: {
                if (this.character_iterator.hasNext()) {
                    this.character_iterator.next();
                    ++this.character_position;
                    break;
                }
                this.character_position = this.host_field.getTextLength();
                this.character_iterator = this.host_field.getEndLink();
                break;
            }
            case 38: 
            case 40: {
                return;
            }
        }
        this.updatePosition();
    }

    @Override
    public void keyR(int key) {
        this.updatePosition();
    }

    public void type(char c) {
        if (this.character_position == 0) {
            this.character_iterator.insertBefore(Character.valueOf(c));
        } else {
            this.character_iterator.insertAfter(Character.valueOf(c));
        }
        ++this.character_position;
    }

    public void giveNewLink(IterB<Character> new_link, int position) {
        this.character_iterator = new_link;
        this.character_position = position;
    }

    public void setHost(adt_textField field) {
        this.host_field = field;
        this.blink();
    }

    private void updatePosition() {
        Pair<Integer, Integer> coords = this.host_field.getCharacterLocation(this.character_position);
        this.setX(coords.getKey().intValue());
        this.setY(coords.getVal().intValue());
    }
}

