/*
 * Decompiled with CFR 0.152.
 */
package Game_Engine.GUI.Components.small;

import BryceMath.Geometry.Rectangle;
import Game_Engine.Engine.Objs.ImageB;
import Game_Engine.Engine.text.TextManager;
import Game_Engine.GUI.Components.Interfaces.TextComponent;
import Game_Engine.GUI.Components.small.gui_look_and_feel;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.PrintStream;
import util.Enums.Justification;

public class gui_label
extends gui_look_and_feel
implements TextComponent {
    private String myMessage = "";
    private int text_size = 20;
    protected String default_text = "";
    private Justification justified = Justification.CENTER;
    private int textX = 0;
    private boolean text_and_sprite = false;

    public gui_label(double x, double y, int w, int h) {
        super(x, y, w, h);
        this.iVars();
    }

    public gui_label(Rectangle r) {
        super(r);
        this.iVars();
    }

    public gui_label(int x, int y, BufferedImage image) {
        super(x, y, image.getWidth(), image.getHeight());
        this.setImage(image);
        this.setDrawBorders(false);
    }

    private void iVars() {
        this.setDrawBorders(false);
        this.myMessage = "";
        this.textX = (int)this.getX() + this.getW() / 2;
    }

    @Override
    public void draw(ImageB i, AffineTransform AT) {
        if (!this.isVisible()) {
            return;
        }
        super.draw(i, AT);
        Graphics2D g = i.getGraphics();
        if (this.sprite == null || this.text_and_sprite) {
            this.drawMessage(g, AT);
        }
    }

    protected void drawMessage(Graphics2D g, AffineTransform AT) {
        double x = this.getX();
        double y = this.getY();
        if (this.myMessage.length() > 0) {
            if (this.justified == Justification.LEFT) {
                this.drawTextLeft(g, AT, x, y, this.myMessage, this.text_size);
                this.textX = (int)x;
            } else {
                this.textX = this.drawTextCenter(g, AT, x + (double)(this.getW() / 2), y + (double)(this.getH() / 2), this.myMessage, this.text_size);
            }
        } else if (this.justified == Justification.LEFT) {
            this.drawTextLeft(g, AT, x, y, this.default_text, this.text_size);
        } else {
            this.drawTextCenter(g, AT, x + (double)(this.getW() / 2), y + (double)(this.getH() / 2), this.default_text, this.text_size);
        }
    }

    public void setText(String in) {
        if (in == null) {
            throw new Error("Labels cannot support null strings");
        }
        if (this.myMessage.equals(in)) {
            return;
        }
        this.myMessage = in;
        this.redraw();
    }

    public void setTextSize(int size) {
        if (this.text_size == size) {
            return;
        }
        this.text_size = size;
        this.redraw();
    }

    public int getTextSize() {
        return this.text_size;
    }

    @Override
    public String getText() {
        return this.myMessage;
    }

    public void setJustification(Justification j) {
        if (this.justified.equals((Object)j)) {
            return;
        }
        this.justified = j;
        this.redraw();
    }

    public Justification getJustification() {
        return this.justified;
    }

    public void fitToContents() {
        this.fitToContents(0);
    }

    public void fitToContents(int min) {
        int h;
        int w_image = 0;
        if (this.sprite != null) {
            w_image = this.sprite.getWidth();
        }
        int w_new = TextManager.getLen(this.getText(), this.text_size, this.getTEX()) + TextManager.getSpacing(this.text_size) * 8;
        if ((w_new = Math.max(w_new, min)) < (h = this.getH())) {
            w_new = h;
        }
        if (w_new > w_image) {
            this.setW(w_new);
        } else {
            this.setW(w_image);
        }
    }

    @Override
    public void serializeTo(PrintStream stream) {
        stream.println(this.myMessage);
    }

    @Override
    public String getSerialName() {
        return "gui_label";
    }

    protected int getTextX() {
        return this.textX;
    }

    @Override
    public boolean isActive() {
        return this.mouseInRegion;
    }

    public void set_text_and_image(boolean flag) {
        this.text_and_sprite = flag;
    }
}

