/*
 * Decompiled with CFR 0.152.
 */
package Game_Engine.GUI.Components.small;

import BryceImages.Operations.ImageFactory;
import BryceMath.Calculations.Colors;
import BryceMath.Geometry.Rectangle;
import Game_Engine.Engine.Objs.ImageB;
import Game_Engine.Engine.Objs.Obj;
import Game_Engine.Engine.Objs.obj_glidable;
import Game_Engine.GUI.Components.small.gui_float;
import Game_Engine.GUI.ImageProccessing.drawing_gui;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import util.interfaces.SerialImageB;

public class gui_look_and_feel
extends obj_glidable
implements SerialImageB {
    public int borderSize;
    protected int padding = 2;
    private Color myColor = null;
    private boolean drawBorders = true;
    private boolean drawBackground = true;
    boolean drawBordersOnMouseHover = false;
    public static final Color C_CLEAR = Colors.Color_hsv(0.0, 0.0, 0.0, 0.0);
    public static final Color C_DISABLED = Colors.Color_hsv(0.0, 0.0, 0.0, 0.0);
    private Color basicColor = C_CLEAR;

    public gui_look_and_feel(double x, double y, int w, int h) {
        super(x, y);
        this.iVars(w, h);
    }

    public gui_look_and_feel(Rectangle r) {
        super(r.getX(), r.getY());
        this.iVars(r.getW(), r.getH());
    }

    private void iVars(int w_in, int h_in) {
        this.borderSize = 2;
        if (this.myColor == null) {
            this.myColor = this.basicColor;
        }
        this.setW(w_in);
        this.setH(h_in);
        this.redraw();
    }

    @Override
    public boolean mouseCollision(int mouseX, int mouseY) {
        boolean result;
        Rectangle bounds = new Rectangle((int)(this.getX() + (double)this.borderSize), (int)(this.getY() + (double)this.borderSize), this.getW() - this.borderSize * 2 - 1, this.getH() - this.borderSize * 2 - 1);
        if (bounds.containsPoint(mouseX, mouseY)) {
            this.mouseInRegion = true;
            return this.isVisible() && this.collidable;
        }
        this.mouseInRegion = result = super.mouseCollision(mouseX, mouseY);
        if (!this.isVisible() || !this.collidable) {
            return false;
        }
        return result;
    }

    @Override
    public void draw(ImageB i, AffineTransform AT) {
        if (!this.isVisible()) {
            return;
        }
        Graphics2D g = i.getGraphics();
        if (this.drawBackground) {
            this.drawBackground(g, AT);
        }
        if (this.sprite != null) {
            double x_new = this.getX() + (double)(this.getW() / 2) - (double)(this.sprite.getWidth() / 2);
            double y_new = this.getY() + (double)(this.getH() / 2) - (double)(this.sprite.getHeight() / 2);
            this.drawImage(g, AT, x_new, y_new, this.sprite);
        }
        if (this.isEnabled() && (this.drawBorders || this.mouseInRegion && this.drawBordersOnMouseHover || this.highlighted)) {
            this.drawBorders(g, AT);
        }
    }

    protected void drawBackground(Graphics2D g, AffineTransform AT) {
        if (this.isEnabled()) {
            g.setColor(this.myColor);
        } else {
            g.setColor(C_DISABLED);
        }
        if (this.isEnabled() && this.drawBorders) {
            this.fillRect(g, AT, this.getX() + (double)this.borderSize + (double)this.padding, this.getY() + (double)this.borderSize + (double)this.padding, this.getW() - this.borderSize * 2 - this.padding * 2, this.getH() - this.borderSize * 2 - this.padding * 2);
        } else {
            this.fillRect(g, AT, this.getX(), this.getY(), this.getW(), this.getH());
        }
    }

    protected void drawBorders(Graphics2D g, AffineTransform AT) {
        if (this.getW() <= 0 || this.getH() <= 0) {
            return;
        }
        if (this.mouseInRegion || this.highlighted) {
            BufferedImage temp = drawing_gui.drawBorders_highlight(this.getW() - this.padding * 2, this.getH() - this.padding * 2);
            this.drawImage(g, AT, this.getX() + (double)this.padding, this.getY() + (double)this.padding, temp);
            return;
        }
        BufferedImage temp = drawing_gui.drawBorders(this.getW() - this.padding * 2, this.getH() - this.padding * 2);
        this.drawImage(g, AT, this.getX() + (double)this.padding, this.getY() + (double)this.padding, temp);
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.isVisible() == visible) {
            return;
        }
        super.setVisible(visible);
        this.redraw();
    }

    public void setDrawBorders(boolean flag) {
        if (this.drawBorders != flag) {
            this.redraw();
        }
        this.drawBorders = flag;
    }

    public int getBorderSize() {
        return this.borderSize;
    }

    public void setBorderSize(int new_size) {
        if (new_size == this.borderSize) {
            return;
        }
        this.redraw();
        this.borderSize = new_size;
        this.redraw();
    }

    public void setColor(Color c) {
        if (!this.myColor.equals(c)) {
            this.redraw();
        }
        this.myColor = c;
    }

    public Color getColor() {
        return this.myColor;
    }

    public void revertColor() {
        if (!this.myColor.equals(this.basicColor)) {
            this.redraw();
        }
        this.myColor = this.basicColor;
    }

    public void setRestingColor(Color c) {
        if (!this.basicColor.equals(c) || !this.myColor.equals(c)) {
            this.redraw();
        }
        this.basicColor = c;
        this.myColor = c;
        this.setColor(c);
    }

    public void makeTransparent() {
        if (!this.myColor.equals(C_CLEAR)) {
            this.redraw();
        }
        this.myColor = C_CLEAR;
        this.collidable = false;
    }

    public void ERROR(String description) {
        this.ERROR(description, 120);
    }

    public void ERROR(String description, int error_time) {
        if (error_time <= 0) {
            throw new Error("Non positive error_time entered.");
        }
        gui_float f = new gui_float(this.getScreenX() + this.getW() / 2, this.getScreenY() + this.getH() / 2, description, error_time);
        f.setDepth(Integer.MIN_VALUE);
        this.getRoom().obj_create((Obj)f);
    }

    @Override
    public BufferedImage serializeImage() {
        BufferedImage image = ImageFactory.blank(this.getW(), this.getH());
        ImageB imageb = new ImageB(image);
        AffineTransform AT = new AffineTransform();
        AT.translate(this.getX(), this.getY());
        this.draw(imageb, AT);
        return image;
    }

    public void setDrawBordersWhenMouseInRegion(boolean val) {
        if (this.drawBordersOnMouseHover == val) {
            return;
        }
        this.drawBordersOnMouseHover = val;
        this.redraw();
    }

    public void drawBordersOnlyOnHover() {
        this.setDrawBorders(false);
        this.setDrawBordersWhenMouseInRegion(true);
    }

    public void setDrawBackground(boolean flag) {
        if (this.drawBackground == flag) {
            return;
        }
        this.drawBackground = flag;
        this.redraw();
    }

    public void setPadding(int i) {
        if (this.padding == i) {
            return;
        }
        this.redraw();
        this.padding = i;
        this.redraw();
    }
}

