/*
 * Decompiled with CFR 0.152.
 */
package Game_Engine.GUI.Components.small;

import BryceMath.Geometry.Rectangle;
import Game_Engine.Engine.Objs.Obj;
import Game_Engine.GUI.Components.large.gui_window;
import Game_Engine.GUI.Components.small.gui_handle;
import Game_Engine.GUI.Components.small.gui_label;
import Game_Engine.GUI.Interfaces.Pingable;
import Game_Engine.GUI.Sprites.StyleSpec;

public class gui_scrollbar
extends gui_window
implements Pingable {
    gui_handle bar;
    gui_label background;
    private static final int border_size = 2;
    private static final int min_x = -2;
    private static final int min_y = -2;

    public gui_scrollbar(double x, double y, int w, int h) {
        super(x, y, w, h);
    }

    public gui_scrollbar(Rectangle r) {
        super(r);
    }

    @Override
    public boolean flag() {
        return this.bar.flag();
    }

    @Override
    public void setFlag(boolean flag) {
        this.bar.setFlag(flag);
    }

    @Override
    public void iObjs() {
        super.iObjs();
        this.formBar();
    }

    private void formBar() {
        int h;
        int w = this.getW();
        if (w > (h = this.getH())) {
            w /= 2;
        } else {
            h /= 2;
        }
        if (w < 8) {
            w = 8;
        }
        if (h < 8) {
            h = 8;
        }
        if (this.bar != null) {
            this.bar.kill();
        }
        this.bar = new gui_handle(-2.0, -2.0, w, h);
        int max_x = this.getMaxX();
        int max_y = this.getMaxY();
        this.bar.setMinX(-2);
        this.bar.setMinY(-2);
        this.bar.setMaxX(max_x);
        this.bar.setMaxY(max_y);
        this.bar.setFlag(true);
        this.bar.setRestingColor(StyleSpec.C_SCROLLBAR_BAR);
        this.obj_create((Obj)this.bar);
        if (this.background != null) {
            this.background.kill();
        }
        this.background = new gui_label(-2.0, -2.0, this.getW(), this.getH());
        this.background.setDepth(1);
        this.background.setColor(StyleSpec.C_SCROLLBAR_BACKGROUND);
        this.obj_create((Obj)this.background);
    }

    private int getMaxX() {
        return this.getW() - this.bar.getW() - 2;
    }

    private int getMaxY() {
        return this.getH() - this.bar.getH() - 2;
    }

    public double getXValue() {
        return this.bar.getXPercentage();
    }

    public double getYValue() {
        return this.bar.getYPercentage();
    }

    public void scroll(int amount) {
        this.bar.setY(this.bar.getY() + (double)(amount * this.getH() / 10));
        this.bar.ensureBounds();
        this.setFlag(true);
    }

    public void setXValue(double percentage) {
        this.bar.setX(-2.0 + (double)(this.getMaxX() - -2) * percentage);
        this.setFlag(true);
    }

    public void setYValue(double percentage) {
        this.bar.setY(-2.0 + (double)(this.getMaxY() - -2) * percentage);
        this.setFlag(true);
    }

    @Override
    public void setW(int w) {
        double percentage = this.getYValue();
        super.setW(w);
        this.formBar();
        this.setXValue(percentage);
    }

    @Override
    public void setH(int h) {
        double percentage = this.getYValue();
        super.setH(h);
        this.formBar();
        this.setYValue(percentage);
    }
}

