/*
 * Decompiled with CFR 0.152.
 */
package Game_Engine.levelEditor.editor_components;

import Data_Structures.ADTs.Bunch2;
import Data_Structures.Structures.List;
import Game_Engine.Engine.Objs.Obj;
import Game_Engine.GUI.Components.large.gui_window;
import Game_Engine.levelEditor.editor_components.obj_button;
import Game_Engine.levelEditor.editor_components.obj_entity;
import Game_Engine.levelEditor.editor_components.obj_grid;
import Game_Engine.levelEditor.room_editor;
import java.io.PrintStream;
import util.SerialB;
import util.deSerialB;

public abstract class gui_level_editor
extends gui_window
implements SerialB,
deSerialB {
    static obj_grid grid_drawer;
    static obj_entity last;
    private boolean addMode = true;

    static {
        last = null;
    }

    public gui_level_editor(double x, double y, int w, int h) {
        super(x, y, w, h);
    }

    @Override
    public void initialize() {
        super.initialize();
        grid_drawer = this.getGridObj();
        this.obj_create((Obj)grid_drawer);
        grid_drawer.setDepth(-2147483647);
    }

    public abstract obj_grid getGridObj();

    public void toggleGrid() {
        if (grid_drawer.isVisible()) {
            grid_drawer.setVisible(false);
            return;
        }
        grid_drawer.setVisible(true);
    }

    @Override
    public void mouseP(int mx, int my) {
        super.mouseP(mx, my);
        if (!this.mouse_left()) {
            return;
        }
        if (!this.addMode) {
            return;
        }
        mx = (int)((double)mx - this.getX() - 2.0);
        my = (int)((double)my - this.getY() - 2.0);
        Bunch2<Integer, Integer> snapCoords = grid_drawer.snapToGrid(mx, my);
        last = this.create_entity(snapCoords.getType1(), snapCoords.getType2());
    }

    @Override
    public void mouseD(int mx, int my) {
        super.mouseD(mx, my);
        if (last == null) {
            return;
        }
        if (!this.mouse_left()) {
            return;
        }
        if (!this.addMode) {
            return;
        }
        mx = (int)((double)mx - this.getX() - 2.0);
        my = (int)((double)my - this.getY() - 2.0);
        Bunch2<Integer, Integer> snapCoords = grid_drawer.snapToGrid(mx, my);
        last.arg2(snapCoords.getType1(), snapCoords.getType2());
    }

    private obj_entity create_entity(int mx, int my) {
        obj_entity e = obj_button.current_entity;
        if (e == null) {
            return null;
        }
        e = e.clone(mx, my);
        e.setDirectionsAttributes(room_editor.getDirectionAttribute());
        this.obj_create((Obj)e);
        this.redraw();
        return e;
    }

    @Override
    public void serializeTo(PrintStream stream) {
        List<Obj> Objs = this.world.getObjList();
        for (Obj o : Objs) {
            if (!(o instanceof obj_entity)) continue;
            o.serializeTo(stream);
        }
        this.serializeNonEntities(stream);
    }

    protected abstract void serializeNonEntities(PrintStream var1);

    @Override
    public String getSerialName() {
        return "Game Level";
    }

    public void killEntities() {
        List<Obj> Objs = this.world.getObjList();
        for (Obj o : Objs) {
            if (!(o instanceof obj_entity)) continue;
            o.kill();
        }
    }

    public void setEditMode(boolean b) {
        obj_entity.setShowKnobs(b);
        this.addMode = !b;
    }
}

