/*
 * Decompiled with CFR 0.152.
 */
package Project.GameGrid;

import GUI.FontDrawing;
import Images.Spr;
import Project.GameGrid.TrackPiece;
import Project.fonts.FontManager;
import SimpleEngine.interfaces.OBJ;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

public class Car
implements OBJ {
    private Dir myDir = Dir.RIGHT;
    boolean moving = false;
    private int load;
    final double straight_per_inc = 0.05;
    final double curve_per_inc = 0.025;
    TrackPiece myLocation;
    double percentage = 0.5;
    int x;
    int y;
    int angle = 0;
    private AffineTransform AT = new AffineTransform();
    boolean alive = true;

    public Car(int load_in) {
        this.load = load_in;
    }

    public Car clone() {
        Car output = new Car(this.load);
        return output;
    }

    public void setLocation(TrackPiece track) {
        this.myLocation = track;
        this.moving = true;
        this.x = this.myLocation.x + this.myLocation.getW() / 2;
        this.y = this.myLocation.y + this.myLocation.getH() / 2;
        this.percentage = 0.5;
        this.angle = 0;
    }

    @Override
    public void draw(Graphics g) {
        this.AT.setToIdentity();
        this.AT.rotate(Math.toRadians(this.angle), this.x, this.y);
        this.AT.translate(this.x - Spr.car.getWidth() / 2, this.y - Spr.car.getHeight() / 2);
        Graphics2D g2 = (Graphics2D)g;
        g2.drawImage(Spr.car, this.AT, null);
        g2.setFont(FontManager.font_12);
        FontDrawing.drawTextCentered(g2, "" + this.load, this.x, this.y);
    }

    @Override
    public void update() {
        if (!this.moving) {
            return;
        }
        int track_index = this.myLocation.track_index;
        if (this.myDir == Dir.RIGHT) {
            if (track_index == 1) {
                this.handle_right_straight();
            } else if (track_index == 4) {
                this.handle_right_curve_up();
            } else if (track_index == 5) {
                this.handle_right_curve_down();
            }
        } else if (this.myDir == Dir.DOWN) {
            if (track_index == 0) {
                this.handle_down_straight();
            } else if (track_index == 4) {
                this.handle_down_curve_left();
            } else if (track_index == 2) {
                this.handle_down_curve_right();
            }
        } else if (this.myDir == Dir.LEFT) {
            if (track_index == 1) {
                this.handle_left_straight();
            } else if (track_index == 3) {
                this.handle_left_curve_down();
            } else if (track_index == 2) {
                this.handle_left_curve_up();
            }
        } else if (this.myDir == Dir.UP) {
            if (track_index == 0) {
                this.handle_up_straight();
            } else if (track_index == 3) {
                this.handle_up_curve_right();
            } else if (track_index == 5) {
                this.handle_up_curve_left();
            }
        }
    }

    private void try_transition(Dir dir) {
        if (this.percentage < 0.95) {
            return;
        }
        TrackPiece newLocation = null;
        switch (dir) {
            case LEFT: {
                newLocation = this.myLocation.getLeft();
                break;
            }
            case UP: {
                newLocation = this.myLocation.getUp();
                break;
            }
            case DOWN: {
                newLocation = this.myLocation.getDown();
                break;
            }
            case RIGHT: {
                newLocation = this.myLocation.getRight();
            }
        }
        if (newLocation == null) {
            this.handle_end_of_track();
        } else {
            this.myLocation = newLocation;
            this.percentage = 0.0;
            this.myDir = dir;
        }
    }

    private void handle_end_of_track() {
        this.moving = false;
        this.alive = false;
    }

    private void handle_right_straight() {
        this.percentage += 0.05;
        this.angle = 0;
        this.x = this.myLocation.x + (int)((double)this.myLocation.getW() * this.percentage);
        this.y = this.myLocation.y + this.myLocation.getH() / 2;
        this.try_transition(Dir.RIGHT);
    }

    private void handle_right_curve_up() {
        this.percentage += 0.025;
        int radius = this.myLocation.getW() * 3 / 4;
        this.angle = (int)(-90.0 * this.percentage);
        double theta = Math.toRadians(90.0 * this.percentage);
        this.x = (int)((double)this.myLocation.x + (double)radius * Math.sin(theta));
        this.y = (int)((double)this.myLocation.y + (double)radius * Math.cos(theta));
        this.try_transition(Dir.UP);
    }

    private void handle_right_curve_down() {
        this.percentage += 0.025;
        int radius = this.myLocation.getW() * 3 / 4;
        this.angle = (int)(90.0 * this.percentage);
        double theta = Math.toRadians(90.0 * this.percentage);
        this.x = (int)((double)this.myLocation.x + (double)radius * Math.sin(theta));
        this.y = (int)((double)(this.myLocation.y + this.myLocation.getH()) - (double)radius * Math.cos(theta));
        this.try_transition(Dir.DOWN);
    }

    private void handle_up_straight() {
        this.percentage += 0.05;
        this.angle = 90;
        this.x = this.myLocation.x + this.myLocation.getW() / 2;
        this.y = this.myLocation.y + this.myLocation.getH() - (int)((double)this.myLocation.getH() * this.percentage);
        this.try_transition(Dir.UP);
    }

    private void handle_up_curve_left() {
        this.percentage += 0.025;
        int radius = this.myLocation.getW() * 3 / 4;
        this.angle = (int)(90.0 - 90.0 * this.percentage);
        double theta = Math.toRadians(90.0 * this.percentage);
        this.x = (int)((double)this.myLocation.x + (double)radius * Math.cos(theta));
        this.y = (int)((double)(this.myLocation.y + this.myLocation.getH()) - (double)radius * Math.sin(theta));
        this.try_transition(Dir.LEFT);
    }

    private void handle_up_curve_right() {
        this.percentage += 0.025;
        int radius = this.myLocation.getW() * 3 / 4;
        this.angle = (int)(-90.0 + 90.0 * this.percentage);
        double theta = Math.toRadians(90.0 * this.percentage);
        this.x = (int)((double)(this.myLocation.x + this.myLocation.getW()) - (double)radius * Math.cos(theta));
        this.y = (int)((double)(this.myLocation.y + this.myLocation.getH()) - (double)radius * Math.sin(theta));
        this.try_transition(Dir.RIGHT);
    }

    private void handle_left_straight() {
        this.percentage += 0.05;
        this.angle = 0;
        this.x = this.myLocation.x + this.myLocation.getW() - (int)((double)this.myLocation.getH() * this.percentage);
        this.y = this.myLocation.y + this.myLocation.getH() / 2;
        this.try_transition(Dir.LEFT);
    }

    private void handle_left_curve_up() {
        this.percentage += 0.025;
        int radius = this.myLocation.getW() * 3 / 4;
        this.angle = (int)(90.0 * this.percentage);
        double theta = Math.toRadians(90.0 * this.percentage);
        this.x = (int)((double)(this.myLocation.x + this.myLocation.getW()) - (double)radius * Math.sin(theta));
        this.y = (int)((double)this.myLocation.y + (double)radius * Math.cos(theta));
        this.try_transition(Dir.UP);
    }

    private void handle_left_curve_down() {
        this.percentage += 0.025;
        int radius = this.myLocation.getW() * 3 / 4;
        this.angle = (int)(-90.0 * this.percentage);
        double theta = Math.toRadians(90.0 * this.percentage);
        this.x = (int)((double)(this.myLocation.x + this.myLocation.getW()) - (double)radius * Math.sin(theta));
        this.y = (int)((double)(this.myLocation.y + this.myLocation.getH()) - (double)radius * Math.cos(theta));
        this.try_transition(Dir.DOWN);
    }

    private void handle_down_straight() {
        this.percentage += 0.05;
        this.angle = 90;
        this.x = this.myLocation.x + this.myLocation.getW() / 2;
        this.y = this.myLocation.y + (int)((double)this.myLocation.getH() * this.percentage);
        this.try_transition(Dir.DOWN);
    }

    private void handle_down_curve_left() {
        this.percentage += 0.025;
        int radius = this.myLocation.getW() * 3 / 4;
        this.angle = (int)(-90.0 + 90.0 * this.percentage);
        double theta = Math.toRadians(90.0 * this.percentage);
        this.x = (int)((double)this.myLocation.x + (double)radius * Math.cos(theta));
        this.y = (int)((double)this.myLocation.y + (double)radius * Math.sin(theta));
        this.try_transition(Dir.LEFT);
    }

    private void handle_down_curve_right() {
        this.percentage += 0.025;
        int radius = this.myLocation.getW() * 3 / 4;
        this.angle = (int)(90.0 - 90.0 * this.percentage);
        double theta = Math.toRadians(90.0 * this.percentage);
        this.x = (int)((double)(this.myLocation.x + this.myLocation.getW()) - (double)radius * Math.cos(theta));
        this.y = (int)((double)this.myLocation.y + (double)radius * Math.sin(theta));
        this.try_transition(Dir.RIGHT);
    }

    public int getLoad() {
        return this.load;
    }

    public static enum Dir {
        LEFT,
        UP,
        RIGHT,
        DOWN;

    }
}

