/*
 * Decompiled with CFR 0.152.
 */
package Project.GameGrid;

import BryceImages.Operations.ImageFactory;
import BryceMath.Calculations.Colors;
import GUI.FontDrawing;
import GUI.OBJ2D;
import Images.Spr;
import Project.GameGrid.Car;
import Project.GameGrid.Car_controller;
import Project.GameGrid.TrackPiece;
import Project.GameGrid.gridSquare;
import Project.GameGrid.gui_LogicMapping;
import Project.Logic_Blocks.block_AND;
import Project.Logic_Blocks.block_False;
import Project.Logic_Blocks.block_NOT;
import Project.Logic_Blocks.block_OR;
import Project.Logic_Blocks.block_True;
import Project.fonts.FontManager;
import Project.interfaces.Consumer;
import Project.interfaces.Logic_Block;
import SimpleEngine.Game_input;
import SimpleEngine.interfaces.MouseInput;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.Set;

public class Grid
extends OBJ2D
implements MouseInput {
    gridSquare[][] squares;
    final int square_size;
    final int num_rows;
    final int num_columns;
    BufferedImage puzzle_components;
    final int w;
    final int h;
    static final int NOTHING_SELECTED = -1;
    public static int track_type = -1;
    final Color C_BACKGROUND = new Color(200, 200, 100);
    private Mode current_mode = Mode.TRACK;
    private int car_load = 0;
    private Car_controller car_controller;
    private LOGIC current_logic = LOGIC.TRUE;
    private int current_direction = 0;
    gui_LogicMapping logic_mapper;
    public static int mouse_x;
    public static int mouse_y;
    public static boolean draw_ghost;
    int mouse_x_initial;
    int mouse_y_initial;
    int mouse_x_current;
    int mouse_y_current;

    static {
        draw_ghost = false;
    }

    public Grid(int x1, int y1, int x2, int y2, int size, gui_LogicMapping mapper) {
        super(x1, y1);
        mouse_x = x1;
        mouse_y = y1;
        this.square_size = size;
        this.w = x2 - x1;
        this.h = y2 - y1;
        this.num_rows = this.h / size + 1;
        this.num_columns = this.w / size + 1;
        this.puzzle_components = ImageFactory.ColorRect(this.C_BACKGROUND, size * this.num_columns, size * this.num_rows);
        this.squares = new gridSquare[this.num_rows][this.num_columns];
        Color color_square = Colors.C_CLEAR;
        BufferedImage image = ImageFactory.ColorRect(color_square, size, size);
        this.car_controller = new Car_controller(this);
        int x = x1;
        while (x < x2) {
            int y = y1;
            while (y < y2) {
                gridSquare square = new gridSquare(x, y, image, this.car_controller);
                square.setDrawBorders(false);
                int index_row = this.getRow(y);
                int index_column = this.getColumn(x);
                square.setAction(() -> this.handle_click(index_row, index_column));
                this.squares[index_row][index_column] = square;
                y += size;
            }
            x += size;
        }
        this.logic_mapper = mapper;
        mapper.setCurrentLogicBlock(this.squares[0][0]);
    }

    public int getRow(int y_in) {
        return (y_in - this.y) / this.square_size;
    }

    public int getColumn(int x_in) {
        return (x_in - this.x) / this.square_size;
    }

    public gridSquare getSquare(int index_x, int index_y) {
        return this.squares[index_y][index_x];
    }

    @Override
    public void draw(Graphics g) {
        g.drawImage(this.puzzle_components, this.x, this.y, null);
        this.actionAll(square -> square.draw(g));
        g.setFont(FontManager.font_gridBlock);
        if (this.current_mode == Mode.SELECTION) {
            Logic_Block root = this.logic_mapper.getCurrentLogicBlock();
            int i = 0;
            while (i < 4) {
                gridSquare input = root.getInput(i);
                FontDrawing.drawText(g, "" + i, input);
                ++i;
            }
        }
        if (this.mouseCollision(mouse_x, mouse_y)) {
            int x_index = (mouse_x - this.x) / this.square_size;
            int x_screen = x_index * this.square_size + this.x;
            int y_index = (mouse_y - this.y) / this.square_size;
            int y_screen = y_index * this.square_size + this.y;
            if (this.current_mode == Mode.TRACK && track_type >= 0 && draw_ghost && this.track_allowed(x_index, y_index)) {
                g.drawImage(Spr.tracks_basalt[track_type], x_screen, y_screen, null);
            }
            gridSquare square2 = this.getSquare(x_index, y_index);
            if (this.current_mode == Mode.LOGIC_BLOCK && !square2.containsLogicBlock()) {
                String message = "";
                switch (this.current_logic) {
                    case TRUE: {
                        message = "T";
                        break;
                    }
                    case FALSE: {
                        message = "F";
                        break;
                    }
                    case AND: {
                        message = "&";
                        break;
                    }
                    case OR: {
                        message = "or";
                        break;
                    }
                    case NOT: {
                        message = "~";
                        break;
                    }
                }
                g.setColor(Colors.Color_hsv(0.0, 0.0, 50.0));
                FontDrawing.drawText(g, message, square2);
            }
            if (this.current_mode == Mode.CAR && !square2.containsCarSpawner()) {
                g.drawImage(Spr.car, x_screen, y_screen + 8, null);
            }
        }
        this.car_controller.draw(g);
    }

    private boolean track_allowed(int x_index, int y_index) {
        if (track_type > 1) {
            return x_index < this.num_columns - 1 && y_index < this.num_rows - 1;
        }
        return true;
    }

    @Override
    public void update() {
        this.actionAll(square -> square.update());
        this.car_controller.update();
    }

    private void handle_click(int index_y, int index_x) {
        switch (this.current_mode) {
            case TRACK: {
                if (!this.track_allowed(index_x, index_y)) break;
                this.handle_track_mode(index_y, index_x);
                break;
            }
            case CAR: {
                this.handle_car_mode(index_y, index_x);
                break;
            }
            case SELECTION: {
                this.handle_selection_mode(index_y, index_x);
                break;
            }
            case LOGIC_BLOCK: {
                this.handle_logic_mode(index_y, index_x);
                break;
            }
            case DIRECTION: {
                this.handle_direction_mode(index_x, index_y);
            }
        }
    }

    private void handle_direction_mode(int index_x, int index_y) {
        gridSquare square = this.getSquare(index_x, index_y);
        if (Game_input.mouse_button == 1) {
            square.setDirection(this.current_direction);
        } else {
            square.setDirection(-1);
        }
        Graphics g = this.getStaticGraphics();
        square.drawComponents(g);
    }

    private void handle_logic_mode(int index_y, int index_x) {
        gridSquare square = this.getSquare(index_x, index_y);
        Logic_Block block = null;
        if (Game_input.mouse_button == 1) {
            switch (this.current_logic) {
                case TRUE: {
                    block = new block_True();
                    break;
                }
                case FALSE: {
                    block = new block_False();
                    break;
                }
                case AND: {
                    block = new block_AND(square);
                    break;
                }
                case OR: {
                    block = new block_OR(square);
                    break;
                }
                case NOT: {
                    block = new block_NOT(square);
                    break;
                }
            }
        }
        square.setLogicBlock(block);
        Graphics g = this.getStaticGraphics();
        square.drawComponents(g);
    }

    private void handle_selection_mode(int index_y, int index_x) {
        int current_button = this.logic_mapper.getCurrentButton();
        gridSquare square = this.getSquare(index_x, index_y);
        if (current_button != -1) {
            Logic_Block block = this.logic_mapper.getCurrentLogicBlock();
            block.setInput(current_button, square);
            this.logic_mapper.reset_input();
            return;
        }
        this.logic_mapper.setCurrentLogicBlock(square);
    }

    private void handle_track_mode(int index_y, int index_x) {
        if (track_type != -1) {
            Graphics g = this.getStaticGraphics();
            if (Game_input.mouse_button == 1) {
                gridSquare square = this.getSquare(index_x, index_y);
                int image_x = square.getX();
                int image_y = square.getY();
                TrackPiece track = new TrackPiece(image_x, image_y, track_type, this, index_x, index_y);
                track.draw(g);
            } else if (Game_input.mouse_button == 3) {
                gridSquare square = this.getSquare(index_x, index_y);
                Set<TrackPiece> track_set = square.deleteAllTracks();
                for (TrackPiece piece : track_set) {
                    piece.draw(g);
                }
            }
            g.dispose();
        }
    }

    private void handle_car_mode(int index_y, int index_x) {
        gridSquare square = this.getSquare(index_x, index_y);
        Graphics g = this.getStaticGraphics();
        if (Game_input.mouse_button == 1) {
            square.setCarSpawn(new Car(this.car_load));
            square.forceCarSpawn();
            square.removeCarSpawn();
            square.drawComponents(g);
        } else if (Game_input.mouse_button == 3) {
            square.removeCarSpawn();
            square.drawComponents(g);
        }
        g.dispose();
    }

    private Graphics getStaticGraphics() {
        Graphics g = this.puzzle_components.getGraphics();
        g.translate(-this.x, -this.y);
        g.setColor(this.C_BACKGROUND);
        return g;
    }

    private void actionAll(Consumer<gridSquare> consumer) {
        int r = 0;
        while (r < this.num_rows) {
            int c = 0;
            while (c < this.num_columns) {
                gridSquare square = this.getSquare(c, r);
                if (square != null) {
                    consumer.consume(square);
                }
                ++c;
            }
            ++r;
        }
    }

    private void actionInBounds(Consumer<gridSquare> consumer, int x, int y) {
        int r = 0;
        while (r < this.num_rows) {
            int c = 0;
            while (c < this.num_columns) {
                gridSquare square = this.getSquare(c, r);
                if (square != null && square.mouseCollision(x, y)) {
                    consumer.consume(square);
                }
                ++c;
            }
            ++r;
        }
    }

    private void actionInMouseRegion(Consumer<gridSquare> consumer, int x, int y) {
        int x1 = Math.min(this.mouse_x_initial, this.mouse_x_current);
        int y1 = Math.min(this.mouse_y_initial, this.mouse_y_current);
        int x2 = Math.max(this.mouse_x_initial, this.mouse_x_current);
        int y2 = Math.max(this.mouse_y_initial, this.mouse_y_current);
        int r1 = this.getRow(x1 -= this.getX());
        int r2 = this.getRow(x2 -= this.getY());
        int c1 = this.getColumn(y1 -= this.getY());
        int c2 = this.getColumn(y2 -= this.getY());
        int r = r1;
        while (r <= r2) {
            int c = c1;
            while (c <= c2) {
                gridSquare square = this.getSquare(c, r);
                if (square != null && square.mouseCollision(x, y)) {
                    consumer.consume(square);
                }
                ++c;
            }
            ++r;
        }
    }

    @Override
    public int getW() {
        return this.w;
    }

    @Override
    public int getH() {
        return this.h;
    }

    @Override
    public void global_mouseP() {
        this.actionAll(square -> square.global_mouseP());
    }

    @Override
    public void global_mouseR() {
        this.actionAll(square -> square.global_mouseR());
    }

    @Override
    public void global_mouseD(int x, int y) {
        this.actionAll(square -> square.global_mouseD(x, y));
    }

    @Override
    public void global_mouseM(int x, int y) {
        this.actionAll(square -> square.global_mouseM(x, y));
        mouse_x = x;
        mouse_y = y;
    }

    @Override
    public void global_mouseScroll(int scroll) {
        this.actionAll(square -> square.global_mouseScroll(scroll));
    }

    @Override
    public void mouseP(int x, int y) {
        this.mouse_x_initial = x;
        this.mouse_y_initial = y;
        this.actionInBounds(square -> square.mouseP(x, y), x, y);
    }

    @Override
    public void mouseR(int x, int y) {
        this.actionInBounds(square -> square.mouseR(x, y), x, y);
    }

    @Override
    public void mouseD(int x, int y) {
        this.mouse_x_current = x;
        this.mouse_y_current = y;
        this.actionInBounds(square -> square.mouseD(x, y), x, y);
    }

    @Override
    public void mouseM(int x, int y) {
        this.actionInBounds(square -> square.mouseM(x, y), x, y);
    }

    @Override
    public void mouseScroll(int x, int y, int scroll) {
        this.actionInBounds(square -> square.mouseP(x, y), x, y);
    }

    public void setTrackType(int type) {
        track_type = type;
        this.current_mode = Mode.TRACK;
    }

    public void setCarMode(int i) {
        this.current_mode = Mode.CAR;
        this.car_load = i;
    }

    public void setSelectionMode() {
        this.current_mode = Mode.SELECTION;
    }

    public void setLogicBlockMode(LOGIC logic) {
        this.current_mode = Mode.LOGIC_BLOCK;
        this.current_logic = logic;
    }

    public void setDirection(int index) {
        this.current_mode = Mode.DIRECTION;
        this.current_direction = index;
    }

    public static enum LOGIC {
        TRUE,
        FALSE,
        AND,
        OR,
        NOT;

    }

    private static enum Mode {
        TRACK,
        CAR,
        SELECTION,
        LOGIC_BLOCK,
        DIRECTION;

    }
}

