/*
 * Decompiled with CFR 0.152.
 */
package Project.GameGrid;

import Images.Spr;
import Project.GameGrid.Dir;
import Project.GameGrid.Grid;
import Project.GameGrid.Sprite;
import Project.GameGrid.gridSquare;
import SimpleEngine.interfaces.OBJ;
import java.awt.Graphics;
import java.util.HashSet;

public class TrackPiece
extends Sprite
implements OBJ {
    HashSet<gridSquare> myGridSet;
    int index_x;
    int index_y;
    int track_index;
    Grid grid;
    public HashSet<gridSquare> locations;

    public TrackPiece(int image_x, int image_y, int track_type, Grid grid, int index_x, int index_y) {
        super(image_x, image_y, Spr.tracks_basalt[track_type], Spr.tracks_rails[track_type]);
        this.track_index = track_type;
        this.index_x = index_x;
        this.index_y = index_y;
        this.grid = grid;
        this.populateLocationSet();
        this.addTrackPiece();
    }

    private void populateLocationSet() {
        this.locations = new HashSet();
        if (Spr.isCurve(this.track_index)) {
            this.locations.add(this.grid.getSquare(this.index_x, this.index_y));
            this.locations.add(this.grid.getSquare(this.index_x + 1, this.index_y));
            this.locations.add(this.grid.getSquare(this.index_x, this.index_y + 1));
            this.locations.add(this.grid.getSquare(this.index_x + 1, this.index_y + 1));
            return;
        }
        this.locations.add(this.grid.getSquare(this.index_x, this.index_y));
    }

    public void addTrackPiece() {
        for (gridSquare square : this.locations) {
            square.addTrack(this);
        }
    }

    public void removeTrackPiece() {
        for (gridSquare square : this.locations) {
            square.removeTrack(this);
        }
    }

    @Override
    public void draw(Graphics g) {
        for (gridSquare square : this.locations) {
            square.drawComponents(g);
        }
    }

    @Override
    public void update() {
    }

    public int getW() {
        return this.images[0].getWidth();
    }

    public int getH() {
        return this.images[0].getHeight();
    }

    public TrackPiece getRight() {
        gridSquare square = null;
        int x_offset = 0;
        int y_offset = 0;
        if (this.track_index == 1) {
            square = this.grid.getSquare(this.index_x + 1, this.index_y);
        } else if (this.track_index == 2) {
            square = this.grid.getSquare(this.index_x + 2, this.index_y + 1);
            x_offset = 1;
            y_offset = 1;
        } else if (this.track_index == 3) {
            square = this.grid.getSquare(this.index_x + 2, this.index_y);
            x_offset = 1;
            y_offset = 0;
        }
        return square.getTrackPiece(Dir.RIGHT, this.index_x + x_offset, this.index_y + y_offset);
    }

    public TrackPiece getUp() {
        gridSquare square = null;
        int x_offset = 0;
        if (this.track_index == 0) {
            square = this.grid.getSquare(this.index_x, this.index_y - 1);
        } else if (this.track_index == 4) {
            square = this.grid.getSquare(this.index_x + 1, this.index_y - 1);
            x_offset = 1;
        } else if (this.track_index == 2) {
            square = this.grid.getSquare(this.index_x, this.index_y - 1);
        }
        return square.getTrackPiece(Dir.UP, this.index_x + x_offset, this.index_y);
    }

    public TrackPiece getLeft() {
        gridSquare square = null;
        int y_offset = 0;
        if (this.track_index == 1) {
            square = this.grid.getSquare(this.index_x - 1, this.index_y);
        } else if (this.track_index == 4) {
            square = this.grid.getSquare(this.index_x - 1, this.index_y + 1);
            y_offset = 1;
        } else if (this.track_index == 5) {
            square = this.grid.getSquare(this.index_x - 1, this.index_y);
        }
        return square.getTrackPiece(Dir.LEFT, this.index_x, this.index_y + y_offset);
    }

    public TrackPiece getDown() {
        int offset_x = 0;
        int offset_y = 0;
        gridSquare square = null;
        if (this.track_index == 0) {
            square = this.grid.getSquare(this.index_x, this.index_y + 1);
        } else if (this.track_index == 5) {
            square = this.grid.getSquare(this.index_x + 1, this.index_y + 2);
            offset_x = 1;
            offset_y = 1;
        } else if (this.track_index == 3) {
            square = this.grid.getSquare(this.index_x, this.index_y + 2);
            offset_y = 1;
        }
        return square.getTrackPiece(Dir.DOWN, this.index_x + offset_x, this.index_y + offset_y);
    }

    public boolean isCurve() {
        return Spr.isCurve(this.track_index);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof TrackPiece)) {
            return false;
        }
        TrackPiece other = (TrackPiece)obj;
        return this.index_x == other.index_x && this.index_y == other.index_y && this.track_index == other.track_index;
    }

    public int hashCode() {
        return this.index_x + 298087 * this.index_y + this.track_index * 300017;
    }
}

