/*
 * Decompiled with CFR 0.152.
 */
package Project.GameGrid;

import Data_Structures.Structures.Timing.TimeB;
import GUI.FontDrawing;
import GUI.UI_Button;
import Images.Spr;
import Project.GameGrid.Car;
import Project.GameGrid.Car_controller;
import Project.GameGrid.Dir;
import Project.GameGrid.Grid;
import Project.GameGrid.Sprite;
import Project.GameGrid.TrackPiece;
import Project.fonts.FontManager;
import Project.interfaces.Logic_Block;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class gridSquare
extends UI_Button
implements Logic_Block {
    private HashSet<TrackPiece> track_set;
    private HashSet<Car> car_set;
    private Car car_spawn;
    private Car_controller car_controller;
    private Logic_Block myLogicBlock = null;
    private gridSquare[] inputs;
    private static final int LEFT = 1;
    private static final int UP = 2;
    private static final int RIGHT = 3;
    private static final int DOWN = 0;
    static final String[] input_names = new String[]{"West", "North", "East", "South"};
    private int myDirection = -1;
    gridSquare input1 = null;
    gridSquare input2 = null;
    TimeB spawn_timer = new TimeB(30);
    int last_input = -1;

    public gridSquare(int x, int y, BufferedImage bounding_image, Car_controller car_controller) {
        super(x, y, "", bounding_image);
        this.track_set = new HashSet();
        this.car_controller = car_controller;
        this.inputs = new gridSquare[4];
        this.inputs[0] = this;
        this.inputs[1] = this;
        this.inputs[2] = this;
        this.inputs[3] = this;
    }

    public void addTrack(TrackPiece spr) {
        this.track_set.add(spr);
    }

    public void removeTrack(TrackPiece piece) {
        if (this.track_set.contains(piece)) {
            this.track_set.remove(piece);
        }
    }

    public boolean containsTrack(TrackPiece piece) {
        return this.track_set.contains(piece);
    }

    public Set<TrackPiece> deleteAllTracks() {
        HashSet copy = (HashSet)this.track_set.clone();
        for (TrackPiece piece : copy) {
            piece.removeTrackPiece();
        }
        return copy;
    }

    public void drawComponents(Graphics g) {
        g.clipRect(this.x, this.y, this.getW(), this.getH());
        g.fillRect(this.x, this.y, this.getW(), this.getH());
        for (Sprite sprite : this.track_set) {
            sprite.draw(g, 0);
        }
        for (Sprite sprite : this.track_set) {
            sprite.draw(g, 1);
        }
        if (this.car_spawn != null) {
            g.drawImage(Spr.car, this.x, this.y + 8, null);
            g.setFont(FontManager.font_12);
            g.setColor(Color.BLACK);
            FontDrawing.drawTextCentered(g, "" + this.car_spawn.getLoad(), this.x + Spr.car.getWidth() / 2, this.y + Spr.car.getHeight() / 2 + 8);
        }
        if (this.myLogicBlock != null) {
            g.setColor(Color.BLACK);
            g.setFont(FontManager.font_smaller);
            FontDrawing.drawText(g, this.myLogicBlock.toString(), this);
        }
        g.setClip(null);
        if (this.myDirection != -1) {
            g.drawImage(Spr.arrow_world[this.myDirection], this.x, this.y, null);
        }
    }

    public void setCarSpawn(Car car) {
        this.car_spawn = car;
    }

    public void removeCarSpawn() {
        this.car_spawn = null;
    }

    @Override
    public void update() {
        super.update();
        this.spawnCar();
    }

    public void spawnCar() {
        Iterator<TrackPiece> iter2 = this.track_set.iterator();
        if (this.spawn_timer.flag() && this.car_spawn != null && this.inputs[0] != null && this.inputs[0].getValue() && iter2.hasNext()) {
            Car car = this.car_spawn.clone();
            car.setLocation(iter2.next());
            this.car_controller.addCar(car);
        }
    }

    public void forceCarSpawn() {
        for (TrackPiece track : this.track_set) {
            if (!Spr.hasLeftConnection(track.track_index)) continue;
            Car car = this.car_spawn.clone();
            car.setLocation(track);
            this.car_controller.addCar(car);
            break;
        }
    }

    public TrackPiece getTrackPiece(Dir dir_incoming, int x_in, int y_in) {
        Dir desired = this.getDesiredDir();
        TrackPiece candidate = null;
        for (TrackPiece track : this.track_set) {
            if (this.connectedFromDirection(dir_incoming, track, x_in, y_in)) {
                candidate = track;
            }
            if (candidate != track || !this.connectedToDirection(desired, track)) continue;
            return track;
        }
        return candidate;
    }

    private boolean connectedFromDirection(Dir dir_incoming, TrackPiece track, int x_in, int y_in) {
        int index = track.track_index;
        switch (dir_incoming) {
            case LEFT: {
                return index == 1 || index == 2 && track.index_y == y_in - 1 && track.index_x == x_in - 2 || index == 3 && track.index_y == y_in && track.index_x == x_in - 2;
            }
            case UP: {
                return index == 0 || index == 3 && track.index_y == y_in - 2 && track.index_x == x_in || index == 5 && track.index_y == y_in - 2 && track.index_x == x_in - 1;
            }
            case DOWN: {
                return index == 0 || index == 2 && track.index_y == y_in + 1 && track.index_x == x_in || index == 4 && track.index_y == y_in + 1 && track.index_x == x_in - 1;
            }
            case RIGHT: {
                return index == 1 || index == 4 && track.index_y == y_in - 1 && track.index_x == x_in + 1 || index == 5 && track.index_y == y_in && track.index_x == x_in + 1;
            }
        }
        return false;
    }

    private boolean connectedToDirection(Dir dir_incoming, TrackPiece track) {
        int index = track.track_index;
        switch (dir_incoming) {
            case LEFT: {
                return Spr.hasLeftConnection(index);
            }
            case UP: {
                return Spr.hasUpConnection(index);
            }
            case DOWN: {
                return Spr.hasDownConnection(index);
            }
            case RIGHT: {
                return Spr.hasRightConnection(index);
            }
        }
        return false;
    }

    public Dir getDesiredDir() {
        switch (this.myDirection) {
            case 1: {
                return Dir.LEFT;
            }
            case 2: {
                return Dir.UP;
            }
            case 3: {
                return Dir.RIGHT;
            }
            case 0: {
                return Dir.DOWN;
            }
        }
        return Dir.RIGHT;
    }

    @Override
    public String[] getInputNames() {
        if (this.car_spawn != null) {
            return new String[]{"Trigger"};
        }
        if (!this.track_set.isEmpty()) {
            return input_names;
        }
        if (this.myLogicBlock != null) {
            return this.myLogicBlock.getInputNames();
        }
        return new String[0];
    }

    @Override
    public boolean getValue() {
        if (this.myDirection == this.last_input) {
            return true;
        }
        if (this.car_spawn != null && this.inputs[0] != this) {
            return this.inputs[0].getValue();
        }
        if (this.myLogicBlock != null) {
            return this.myLogicBlock.getValue();
        }
        return false;
    }

    @Override
    public void setInput(int index, gridSquare square) {
        this.inputs[index] = square;
    }

    @Override
    public gridSquare getInput(int index) {
        this.last_input = index;
        return this.inputs[index];
    }

    public void setLogicBlock(Logic_Block block) {
        this.myLogicBlock = block;
    }

    @Override
    public void mouseM(int x, int y) {
        super.mouseM(x, y);
        Grid.mouse_x = x;
        Grid.mouse_y = y;
        this.updateGridGhostImage();
    }

    @Override
    public void mouseR(int x, int y) {
        super.mouseR(x, y);
        this.updateGridGhostImage();
    }

    @Override
    public void mouseD(int x, int y) {
        super.mouseD(x, y);
        this.action();
    }

    private void updateGridGhostImage() {
        int track_index = Grid.track_type;
        Grid.draw_ghost = true;
        for (TrackPiece piece : this.track_set) {
            if (piece.x != this.x || piece.y != this.y || piece.track_index != track_index) continue;
            Grid.draw_ghost = false;
            return;
        }
    }

    public boolean containsLogicBlock() {
        return this.myLogicBlock != null;
    }

    public boolean containsCarSpawner() {
        return this.car_spawn != null;
    }

    public void setDirection(int direction_index) {
        this.myDirection = direction_index;
    }

    public static String getMessageForTrackIndex(int index) {
        switch (index) {
            case 1: {
                return "Westward";
            }
            case 3: {
                return "Eastward";
            }
            case 2: {
                return "Northward";
            }
            case 0: {
                return "Southern";
            }
        }
        return "Direction NOT FOUND";
    }

    private static enum Type {
        NONE,
        CAR_SPAWN,
        AND,
        OR,
        NEGATION,
        NUMBER;

    }
}

