/*
 * Decompiled with CFR 0.152.
 */
package Project.GameGrid;

import BryceImages.Operations.ImageFactory;
import GUI.UI_Button;
import Project.fonts.FontManager;
import Project.interfaces.Logic_Block;
import SimpleEngine.SimpleRoom;
import SimpleEngine.interfaces.MouseInput;
import java.awt.Color;
import java.awt.image.BufferedImage;

public class gui_LogicMapping
extends SimpleRoom
implements MouseInput {
    public static final int NUM_INPUTS = 4;
    public static final int NO_INPUT = -1;
    private UI_Button[] input_buttons = new UI_Button[4];
    private int current_button = -1;
    private Logic_Block current_block = null;
    private static final int h = 62;

    public gui_LogicMapping(int x, int y) {
        super(x, y, 248, 62);
        Color c = new Color(255, 255, 255);
        BufferedImage image = ImageFactory.ColorRect(c, 62, 62);
        int i = 0;
        while (i < 4) {
            UI_Button button = new UI_Button(x + 62 * i, y, "" + i, image);
            int index = i;
            button.setAction(() -> {
                int n2 = this.current_button = index;
            });
            button.setFont(FontManager.font_smaller);
            this.input_buttons[i] = button;
            this.addOBJ(button);
            ++i;
        }
    }

    public void setCurrentLogicBlock(Logic_Block block) {
        this.current_block = block;
        String[] values = block.getInputNames();
        int len = Math.min(4, values.length);
        int i = 0;
        while (i < len) {
            this.input_buttons[i].setText(String.valueOf(i) + ": " + values[i]);
            ++i;
        }
        i = len;
        while (i < 4) {
            this.input_buttons[i].setText("");
            ++i;
        }
    }

    public Logic_Block getCurrentLogicBlock() {
        return this.current_block;
    }

    public int getCurrentButton() {
        return this.current_button;
    }

    public void reset_input() {
        this.current_button = -1;
    }

    @Override
    public void setX(int x) {
        super.setX(x);
        UI_Button[] uI_ButtonArray = this.input_buttons;
        int n = this.input_buttons.length;
        int n2 = 0;
        while (n2 < n) {
            UI_Button b = uI_ButtonArray[n2];
            b.setX(x);
            x += 62;
            ++n2;
        }
    }

    @Override
    public void setY(int y) {
        super.setY(y);
        UI_Button[] uI_ButtonArray = this.input_buttons;
        int n = this.input_buttons.length;
        int n2 = 0;
        while (n2 < n) {
            UI_Button b = uI_ButtonArray[n2];
            b.setY(y);
            ++n2;
        }
    }
}

