/*
 * Decompiled with CFR 0.152.
 */
package Project;

import BryceImages.Operations.ImageFactory;
import GUI.UI_Button;
import GUI.UI_SelectionButton;
import GUI.UI_Slider;
import GUI.UI_TextBox;
import Images.Spr;
import Project.GameGrid.Grid;
import Project.GameGrid.gridSquare;
import Project.GameGrid.gui_LogicMapping;
import Project.fonts.FontManager;
import SimpleEngine.MainRoom;
import java.awt.Color;
import java.awt.Graphics;
import util.interfaces.Action;

public class aaTrainOp
extends MainRoom {
    public static void main(String[] args) {
        Spr.renderTracks();
        new aaTrainOp("Train Ops!", 1200, 800);
    }

    public aaTrainOp(String gameName, int w, int h) {
        super(gameName, w, h);
    }

    @Override
    public void initialize(int w, int h) {
        int separation;
        UI_TextBox box;
        int wr = 200;
        int hr = 64;
        int menu_y = 64;
        UI_TextBox message_box = box = new UI_TextBox(0, menu_y / 4, 400, 32, "Please Click on a Button");
        box.setFont(FontManager.block_label);
        this.addOBJ(box);
        gui_LogicMapping logicMapper = new gui_LogicMapping(this.x, this.y + 64);
        Grid world = new Grid(8, 216, w - 16, h - 32, 32, logicMapper);
        this.addOBJ(world);
        int x = separation = 32;
        x += separation + this.gui_track_pieces(x, menu_y, world, box);
        x += separation + this.gui_car(x, menu_y, world, box);
        x += separation + this.gui_arrows(x, menu_y, world, box);
        box = new UI_TextBox(x, menu_y, 300, 64, "Click grid to build!");
        box.setFont(FontManager.font_LOGIC_BLOCK);
        this.addOBJ(box);
        box = new UI_TextBox(x, menu_y + 64 + 8, 300, 64, "Right Click to remove");
        box.setFont(FontManager.font_LOGIC_BLOCK);
        this.addOBJ(box);
        UI_SelectionButton b = new UI_SelectionButton(this.getW() - 32 - 16, 16, "X", ImageFactory.blank(32, 32));
        b.setAction(() -> System.exit(0));
        String message = "Exit Program";
        b.setOnMouseMove(() -> aaTrainOp.do_and_move(() -> message_box.setText(message), message_box, this.getW() - message_box.getW() - 64, b.getY()));
        b.setFont(FontManager.font_LOGIC_BLOCK);
        this.addOBJ(b);
    }

    private void gui_world(int x, int h) {
    }

    private int gui_logic_blocks(int x, int y, Grid world, UI_TextBox box) {
        int y2 = y;
        int x2 = x;
        UI_SelectionButton b = new UI_SelectionButton(x2, y2, "True", ImageFactory.blank(64, 64));
        b.setAction(() -> world.setLogicBlockMode(Grid.LOGIC.TRUE));
        String message = "Create a True block.";
        b.setOnMouseMove(() -> aaTrainOp.do_and_move(() -> box.setText(message), box, b.getX(), b.getY()));
        b.setFont(FontManager.font_LOGIC_BLOCK);
        this.addOBJ(b);
        b = new UI_SelectionButton(x2 += 64, y2, "False", ImageFactory.blank(64, 64));
        b.setAction(() -> world.setLogicBlockMode(Grid.LOGIC.FALSE));
        message = "Create a False Block.";
        b.setOnMouseMove(() -> aaTrainOp.do_and_move(() -> box.setText(message), box, b.getX(), b.getY()));
        b.setFont(FontManager.font_LOGIC_BLOCK);
        this.addOBJ(b);
        b = new UI_SelectionButton(x2 += 64, y2, "and", ImageFactory.blank(64, 64));
        b.setAction(() -> world.setLogicBlockMode(Grid.LOGIC.AND));
        message = "Create a conjunctive AND block.";
        b.setOnMouseMove(() -> aaTrainOp.do_and_move(() -> box.setText(message), box, b.getX(), b.getY()));
        b.setFont(FontManager.font_LOGIC_BLOCK);
        this.addOBJ(b);
        b = new UI_SelectionButton(x2 += 64, y2, "or", ImageFactory.blank(64, 64));
        b.setAction(() -> world.setLogicBlockMode(Grid.LOGIC.OR));
        message = "Create a disjunctive OR block.";
        b.setOnMouseMove(() -> aaTrainOp.do_and_move(() -> box.setText(message), box, b.getX(), b.getY()));
        b.setFont(FontManager.font_LOGIC_BLOCK);
        this.addOBJ(b);
        b = new UI_SelectionButton(x2 += 64, y2, "not", ImageFactory.blank(64, 64));
        b.setAction(() -> world.setLogicBlockMode(Grid.LOGIC.NOT));
        message = "Create a Negation Block.";
        b.setOnMouseMove(() -> aaTrainOp.do_and_move(() -> box.setText(message), box, b.getX(), b.getY()));
        b.setFont(FontManager.font_LOGIC_BLOCK);
        this.addOBJ(b);
        int w = (x2 += 64) - x;
        UI_TextBox label = new UI_TextBox(x, y + 64, w, 32, "logic");
        label.setFont(FontManager.block_label);
        this.addOBJ(label);
        return w;
    }

    private int gui_track_pieces(int x, int y, Grid world, UI_TextBox box) {
        int x2 = x;
        int i = 0;
        while (i < 6) {
            UI_SelectionButton b = new UI_SelectionButton(x + i * 64, y, "", Spr.full_tracks[i]);
            int index = i;
            b.setAction(() -> world.setTrackType(index));
            b.setOnKeyP(key -> aaTrainOp.do_if(key, 49 + index, () -> world.setTrackType(index)));
            String message = "Create a Track Piece";
            b.setOnMouseMove(() -> aaTrainOp.do_and_move(() -> box.setText(message), box, b.getX(), b.getY()));
            if (i == 0 || i == 1) {
                b.setImageOffsetX(16);
                b.setImageOffsetY(16);
            }
            b.setW(64);
            b.setH(64);
            this.addOBJ(b);
            if (i == 1) {
                b.select();
                world.setTrackType(1);
            }
            this.createHotKey(("" + (i + 1)).charAt(0), x2, y);
            x2 += 64;
            ++i;
        }
        int w = x2 - x;
        UI_TextBox label = new UI_TextBox(x, y + 64, x2 - x, 32, "Track Pieces");
        label.setFont(FontManager.block_label);
        this.addOBJ(label);
        return w;
    }

    private int gui_car(int x, int y, Grid world, UI_TextBox box) {
        int i = 0;
        UI_SelectionButton b = new UI_SelectionButton(x += 16, y + Spr.car.getHeight() * i, "" + i, Spr.car_icon);
        b.setFont(FontManager.font_15);
        b.setTextColor(Color.BLACK);
        b.setW(64);
        b.setH(64);
        b.setImageOffsetY(16);
        b.setImageOffsetX(8);
        b.setTextOffset(0, -4);
        this.addOBJ(b);
        UI_Slider slider = new UI_Slider(x - 16, y + 64, 96, 32, 10);
        slider.setOnSlide(state -> b.setText("" + state));
        slider.setAction(() -> ((UI_SelectionButton)b).select());
        b.setAction(() -> world.setCarMode(slider.getState()));
        b.setOnKeyP(key -> aaTrainOp.do_if(key, 67, () -> world.setCarMode(slider.getState())));
        String message = "Create a car with load ";
        b.setOnMouseMove(() -> aaTrainOp.do_and_move(() -> box.setText(String.valueOf(message) + slider.getState()), box, b.getX(), b.getY()));
        this.addOBJ(slider);
        this.createHotKey('c', x, y);
        return 96;
    }

    private void gui_selection_button(int x, int y, Grid world, UI_TextBox box, gui_LogicMapping logic) {
        UI_Button b = new UI_Button(x, y, "Select", ImageFactory.blank(256, 64));
        b.setAction(() -> world.setSelectionMode());
        b.setOnMouseMove(() -> box.setText("Go into relationship mapping mode."));
        this.addOBJ(b);
        logic.setX(x);
        logic.setY(y + 64);
    }

    private int gui_arrows(int x, int y, Grid world, UI_TextBox box) {
        int x2 = x;
        int i = 0;
        while (i < 4) {
            UI_SelectionButton b = new UI_SelectionButton(x + i * 64, y, "", Spr.arrow_icon[i]);
            int index = i;
            b.setAction(() -> world.setDirection(index));
            String message = String.valueOf(gridSquare.getMessageForTrackIndex(i)) + " switching.";
            b.setOnMouseMove(() -> aaTrainOp.do_and_move(() -> box.setText(message), box, b.getX() - 32, b.getY()));
            int keycode = index != 3 ? 55 + index : 48;
            b.setOnKeyP(key -> aaTrainOp.do_if(key, keycode, () -> world.setTrackType(index)));
            if (index != 3) {
                this.createHotKey(("" + (i + 7)).charAt(0), x2, y);
            } else {
                this.createHotKey('0', x2, y);
            }
            b.setImageOffsetX(7);
            b.setImageOffsetY(7);
            b.setW(64);
            b.setH(64);
            this.addOBJ(b);
            x2 += 64;
            ++i;
        }
        int w = x2 - x;
        UI_TextBox label = new UI_TextBox(x, y + 64, x2 - x, 32, "Switch Directions");
        label.setFont(FontManager.block_label);
        this.addOBJ(label);
        return w;
    }

    private static void do_if(Object o, Object expected, Action action) {
        if (o.equals(expected)) {
            action.action();
        }
    }

    private static void do_and_move(Action action, UI_TextBox box, int x, int y) {
        action.action();
        box.setX(x);
    }

    @Override
    public void draw(Graphics g) {
        g.setColor(Color.BLACK);
        g.drawRect(0, 0, this.getW() - 1, this.getH() - 1);
        super.draw(g);
    }

    private void createHotKey(char c, int x, int y) {
        UI_TextBox hotkey = new UI_TextBox(x + 16, y + 64 + 32 + 16, 32, 32, "" + c);
        hotkey.setFont(FontManager.font_12);
        this.addOBJ(hotkey);
    }
}

