/*
 * Decompiled with CFR 0.152.
 */
package SimpleEngine;

import SimpleEngine.Game_output;
import SimpleEngine.interfaces.Room;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

public class Game_input {
    public static int mouse_x;
    public static int mouse_y;
    public static final int LEFT_MOUSE = 1;
    public static final int MIDDLE_MOUSE = 2;
    public static final int RIGHT_MOUSE = 3;
    public static int mouse_button;
    private Room data;
    private key_input l_key;
    private mouse_input l_mouse;
    private Game_output output;

    static {
        mouse_button = 0;
    }

    public Game_input(Room data_in, Game_output output_in) {
        this.data = data_in;
        this.l_key = new key_input();
        this.l_mouse = new mouse_input();
        this.output = output_in;
        this.start();
    }

    public void start() {
        this.output.setFocusable(true);
        this.output.requestFocus();
        this.output.addKeyListener(this.l_key);
        this.output.addMouseListener(this.l_mouse);
        this.output.addMouseMotionListener(this.l_mouse);
        this.output.addMouseWheelListener(this.l_mouse);
        this.output.setFocusTraversalKeysEnabled(false);
    }

    public void stop() {
        this.output.removeKeyListener(this.l_key);
        this.output.removeMouseListener(this.l_mouse);
        this.output.removeMouseMotionListener(this.l_mouse);
        this.output.removeMouseWheelListener(this.l_mouse);
    }

    public KeyAdapter getKeyListener() {
        return new key_input();
    }

    public MouseAdapter getMouseListener() {
        return new mouse_input();
    }

    public MouseMotionListener getMouseMotionListener() {
        return new mouse_input();
    }

    public MouseWheelListener getMouseWheelListener() {
        return new mouse_input();
    }

    private void computeMouseCoords(MouseEvent e) {
        mouse_x = e.getX() - this.output.x1;
        mouse_y = e.getY() - this.output.y1;
        mouse_x = mouse_x * this.data.getW() / (this.output.x2 - this.output.x1);
        mouse_y = mouse_y * this.data.getH() / (this.output.y2 - this.output.y1);
    }

    private class key_input
    extends KeyAdapter {
        private key_input() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            Game_input.this.data.keyP(e.getKeyCode());
        }

        @Override
        public void keyReleased(KeyEvent e) {
            Game_input.this.data.keyR(e.getKeyCode());
        }
    }

    private class mouse_input
    extends MouseAdapter
    implements MouseMotionListener {
        private mouse_input() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            mouse_button = e.getButton();
            Game_input.this.computeMouseCoords(e);
            Game_input.this.data.mouseP(mouse_x, mouse_y);
            Game_input.this.data.global_mouseP();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            mouse_button = e.getButton();
            Game_input.this.computeMouseCoords(e);
            Game_input.this.data.mouseR(mouse_x, mouse_y);
            Game_input.this.data.global_mouseR();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Game_input.this.computeMouseCoords(e);
            Game_input.this.data.mouseM(mouse_x, mouse_y);
            Game_input.this.data.global_mouseM(mouse_x, mouse_y);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Game_input.this.computeMouseCoords(e);
            Game_input.this.data.mouseD(mouse_x, mouse_y);
            Game_input.this.data.global_mouseD(mouse_x, mouse_y);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            int rotate = e.getWheelRotation();
            Game_input.this.data.global_mouseScroll(rotate);
        }
    }
}

