/*
 * Decompiled with CFR 0.152.
 */
package SimpleEngine;

import GUI.OBJ2D;
import SimpleEngine.interfaces.KeyInput;
import SimpleEngine.interfaces.MouseInput;
import SimpleEngine.interfaces.OBJ;
import SimpleEngine.interfaces.Room;
import java.awt.Graphics;
import java.util.HashSet;

public abstract class SimpleRoom
extends OBJ2D
implements Room {
    private int w;
    private int h;
    HashSet<OBJ> set;

    public SimpleRoom(int x, int y, int w, int h) {
        super(x, y);
        this.w = w;
        this.h = h;
        this.set = new HashSet();
    }

    public SimpleRoom(int w, int h) {
        super(0, 0);
        this.w = w;
        this.h = h;
        this.set = new HashSet();
    }

    @Override
    public int getW() {
        return this.w;
    }

    @Override
    public int getH() {
        return this.h;
    }

    @Override
    public void update() {
        for (OBJ o : this.set) {
            o.update();
        }
    }

    @Override
    public void draw(Graphics g) {
        for (OBJ o : this.set) {
            o.draw(g);
        }
    }

    public void addOBJ(OBJ obj) {
        this.set.add(obj);
    }

    public void removeOBJ(OBJ obj) {
        this.set.remove(obj);
    }

    @Override
    public void global_mouseP() {
        for (OBJ o : this.set) {
            if (!(o instanceof MouseInput)) continue;
            MouseInput o2 = (MouseInput)((Object)o);
            o2.global_mouseP();
        }
    }

    @Override
    public void global_mouseR() {
        for (OBJ o : this.set) {
            if (!(o instanceof MouseInput)) continue;
            MouseInput o2 = (MouseInput)((Object)o);
            o2.global_mouseR();
        }
    }

    @Override
    public void global_mouseD(int x, int y) {
        for (OBJ o : this.set) {
            if (!(o instanceof MouseInput)) continue;
            MouseInput o2 = (MouseInput)((Object)o);
            o2.global_mouseD(x, y);
        }
    }

    @Override
    public void global_mouseM(int x, int y) {
        for (OBJ o : this.set) {
            if (!(o instanceof MouseInput)) continue;
            MouseInput o2 = (MouseInput)((Object)o);
            o2.global_mouseM(x, y);
        }
    }

    @Override
    public void global_mouseScroll(int scroll) {
        for (OBJ o : this.set) {
            if (!(o instanceof MouseInput)) continue;
            MouseInput o2 = (MouseInput)((Object)o);
            o2.global_mouseScroll(scroll);
        }
    }

    @Override
    public void mouseP(int x, int y) {
        for (OBJ o : this.set) {
            MouseInput o2;
            if (!(o instanceof MouseInput) || !(o2 = (MouseInput)((Object)o)).mouseCollision(x, y)) continue;
            o2.mouseP(x, y);
        }
    }

    @Override
    public void mouseR(int x, int y) {
        for (OBJ o : this.set) {
            MouseInput o2;
            if (!(o instanceof MouseInput) || !(o2 = (MouseInput)((Object)o)).mouseCollision(x, y)) continue;
            o2.mouseR(x, y);
        }
    }

    @Override
    public void mouseD(int x, int y) {
        for (OBJ o : this.set) {
            MouseInput o2;
            if (!(o instanceof MouseInput) || !(o2 = (MouseInput)((Object)o)).mouseCollision(x, y)) continue;
            o2.mouseD(x, y);
        }
    }

    @Override
    public void mouseM(int x, int y) {
        for (OBJ o : this.set) {
            MouseInput o2;
            if (!(o instanceof MouseInput) || !(o2 = (MouseInput)((Object)o)).mouseCollision(x, y)) continue;
            o2.mouseM(x, y);
        }
    }

    @Override
    public void mouseScroll(int x, int y, int scroll) {
        for (OBJ o : this.set) {
            MouseInput o2;
            if (!(o instanceof MouseInput) || !(o2 = (MouseInput)((Object)o)).mouseCollision(x, y)) continue;
            o2.mouseScroll(x, y, scroll);
        }
    }

    @Override
    public void keyP(int key) {
        for (OBJ o : this.set) {
            if (!(o instanceof KeyInput)) continue;
            KeyInput o2 = (KeyInput)((Object)o);
            o2.keyP(key);
        }
    }

    @Override
    public void keyR(int key) {
        for (OBJ o : this.set) {
            if (!(o instanceof KeyInput)) continue;
            KeyInput o2 = (KeyInput)((Object)o);
            o2.keyR(key);
        }
    }

    @Override
    public boolean mouseCollision(int x, int y) {
        if (x < this.getX() || x >= this.getX() + this.w || y < this.getY() || y >= this.getY() + this.getH()) {
            return false;
        }
        for (OBJ o : this.set) {
            MouseInput o2;
            if (!(o instanceof MouseInput) || !(o2 = (MouseInput)((Object)o)).mouseCollision(x, y)) continue;
            return true;
        }
        return true;
    }
}

