/*
 * Decompiled with CFR 0.152.
 */
package util;

import Data_Structures.Structures.HashingClasses.AArray;
import Data_Structures.Structures.List;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;

public class FileIO {
    private static AArray<File, PrintStream> files = new AArray();

    public static File parseFile(String ... path) {
        int len = path.length;
        if (len == 0) {
            throw new Error("Null path names are not accepted");
        }
        File output = new File(path[0]);
        int i = 1;
        while (i < len) {
            output = new File(output, path[i]);
            ++i;
        }
        return output;
    }

    public static File parseFile(File file_dir, String ... path) {
        File output = file_dir;
        int len = path.length;
        if (len == 0) {
            throw new Error("Null path names are not accepted");
        }
        int i = 0;
        while (i < len) {
            output = new File(output, path[i]);
            ++i;
        }
        return output;
    }

    public static void createFile(File file) {
        if (files.lookup(file) != null) {
            throw new Error("Files should never be created when they are already open.");
        }
        File parent = file.getParentFile();
        if (parent != null && !parent.exists()) {
            file.getParentFile().mkdirs();
        }
        FileIO.openFile(file);
    }

    public static void openFile(File file) {
        if (files.lookup(file) != null) {
            throw new Error("Files should never be opened multiple times before they are closed!");
        }
        File parent = file.getParentFile();
        if (parent != null && !parent.exists()) {
            throw new Error("The file " + file + " does not exist!\n" + "Try using FileIO.createFile() instead.");
        }
        try {
            files.insert(file, new PrintStream(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static boolean closeFile(File file) {
        return files.remove_key(file);
    }

    public void restoreDefaultPrintStream() {
        System.setOut(new PrintStream(new FileOutputStream(FileDescriptor.out)));
    }

    public static void print(File file, Object o) {
        PrintStream stream = files.lookup(file);
        if (stream == null) {
            throw new Error("File not open");
        }
        stream.println(o);
    }

    public static void print(File file, Object ... objs) {
        PrintStream stream = files.lookup(file);
        if (stream == null) {
            throw new Error("File not open");
        }
        Object[] objectArray = objs;
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            stream.println(o);
            ++n2;
        }
    }

    public static boolean isFileOpen(File file) {
        return files.lookup(file) != null;
    }

    public static PrintStream getStream(File file) {
        PrintStream stream = files.lookup(file);
        if (stream == null) {
            throw new Error("File not open");
        }
        return stream;
    }

    public static List<String> readFile(File file) {
        List<String> output = new List<String>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try {
            String line = br.readLine();
            while (line != null) {
                output.add(line);
                line = br.readLine();
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return output;
    }

    public static String getExtension(File file) {
        String path = file.getAbsolutePath();
        int dot_index = FileIO.getDotIndex(path);
        if (dot_index == -1) {
            return null;
        }
        String extension = path.substring(dot_index);
        return extension;
    }

    public static String getChildName(File file) {
        String path = file.getName();
        int dot_index = FileIO.getDotIndex(path);
        if (dot_index == -1) {
            return path;
        }
        String non_extension = path.substring(0, dot_index - 1);
        return non_extension;
    }

    public static String getDirectoryName(File file) {
        return file.getPath();
    }

    private static int getDotIndex(String filename) {
        int len = filename.length();
        int len_ext = 0;
        while (filename.charAt(len - len_ext - 1) != '.') {
            if (++len_ext != len) continue;
            return -1;
        }
        return len - len_ext;
    }
}

