/*
 * Decompiled with CFR 0.152.
 */
package util;

import Data_Structures.Structures.List;
import util.Print;
import util.StringParser;
import util.testing;

public class aaTestingAndCasePrinter {
    public static void main(String[] args) {
        aaTestingAndCasePrinter test = new aaTestingAndCasePrinter();
        test.printCases();
        test.testStringParser();
        Print.print("All Tests have passed!");
    }

    private void printCases() {
    }

    private void testStringParser() {
        String e1 = "";
        List<String> expected = this.L(new String[0]);
        testing.ASSERT(this.correctParsing(e1, expected));
        e1 = "1";
        expected = this.L("1");
        testing.ASSERT(this.correctParsing(e1, expected));
        e1 = "1234321";
        expected = this.L("1234321");
        testing.ASSERT(this.correctParsing(e1, expected));
        e1 = "1234321.2432749789723498";
        expected = this.L("1234321.2432749789723498");
        testing.ASSERT(this.correctParsing(e1, expected));
        e1 = "42357890274589742324779327498.43642873463298789";
        expected = this.L("42357890274589742324779327498.43642873463298789");
        testing.ASSERT(this.correctParsing(e1, expected));
        e1 = "A";
        expected = this.L("A");
        testing.ASSERT(this.correctParsing(e1, expected));
        e1 = "1 + 1";
        expected = this.L("1", "+", "1");
        testing.ASSERT(this.correctParsing(e1, expected));
        e1 = "5+ 7 + 8+3.325";
        expected = this.L("5", "+", "7", "+", "8", "+", "3.325");
        testing.ASSERT(this.correctParsing(e1, expected));
        e1 = "6 + y + 4.2";
        expected = this.L("6", "+", "y", "+", "4.2");
        testing.ASSERT(this.correctParsing(e1, expected));
        e1 = "6x";
        expected = this.L("6", "x");
        testing.ASSERT(this.correctParsing(e1, expected));
        e1 = "x^2";
        expected = this.L("x", "^", "2");
        testing.ASSERT(this.correctParsing(e1, expected));
        e1 = "x^2 + 5x + 1";
        expected = this.L("x", "^", "2", "+", "5", "x", "+", "1");
        testing.ASSERT(this.correctParsing(e1, expected));
        e1 = "x^2 + 5x + 1";
        expected = this.L("x", "^", "2", "+", "5", "x", "+", "1");
        testing.ASSERT(this.correctParsing(e1, expected));
        e1 = "7xyz^2 + 6x^7/23^2";
        expected = this.L("7", "x", "y", "z", "^", "2", "+", "6", "x", "^", "7", "/", "23", "^", "2");
        testing.ASSERT(this.correctParsing(e1, expected));
        e1 = "5 + (8xy +5)/[54-x] + {5+x^{5}}^{ei}";
        expected = this.L("5", "+", "(", "8xy+5", ")", "/", "[", "54-x", "]", "+", "{", "5+x^{5}", "}", "^", "{", "ei", "}");
        testing.ASSERT(this.correctParsing(e1, expected));
        e1 = "{5{3{2}}}}6";
        expected = this.L("{", "5{3{2}}", "}", "6");
        testing.ASSERT(this.correctParsing(e1, expected));
        e1 = "45}]})})5";
        expected = this.L("45", "5");
        testing.ASSERT(this.correctParsing(e1, expected));
        e1 = "({[{{{{[[[{({((45";
        expected = this.L("(", "{[{{{{[[[{({((45", ")");
        testing.ASSERT(this.correctParsing(e1, expected));
        e1 = "'Bryce' + 'work' = \"Joy\"?";
        expected = this.L("'", "Bryce", "'", "+", "'", "work", "'", "=", "\"", "Joy", "\"");
        testing.ASSERT(this.correctParsing(e1, expected));
        e1 = "(";
        expected = this.L(new String[0]);
        testing.ASSERT(this.correctParsing(e1, expected));
    }

    private boolean correctParsing(String input, List<String> expected_output) {
        return StringParser.parseExpression(input).equals(expected_output);
    }

    private List<String> L(String ... input) {
        return new List<String>(input);
    }
}

